/*
 * Decompiled with CFR 0.152.
 */
package perenono.pac.easytable;

import com.ibm.regex.Match;
import com.ibm.regex.RegularExpression;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import perenono.pac.easytable.CTable;
import perenono.pac.easytable.ITableInOut;
import perenono.pac.easytable.ValidException;

public class ATable {
    public static final String LIST = "List";
    public static final String LISTEDITABLE = "ListEditable";
    public static final String STRING = "String";
    private CTable controlleur;
    private int nb_col;
    private int key = -1;
    private String title;
    private boolean addPossible = true;
    private boolean supPossible = true;
    private boolean editable = true;
    private ResourceBundle prop;
    private boolean dragPossible = false;
    private boolean dropPossible = false;
    private String[] nameColumn;
    private String[] tooltipColumn;
    private String[] typeColumn;
    private String[] initValue;
    private String[] testRegex;
    private boolean[] champsRequis;
    private boolean[] readOnly;
    private String[][] listValue;
    private Vector value;
    public static boolean load = false;
    public static char separator;
    public static String erreur;
    public static String loadClassMessage1;
    public static String loadClassMessage2;
    public static String valueRequireMessage;
    public static String doublonMessage;
    public static String valueNotCorrectMessage;
    public static String deleteMessage;
    private ITableInOut loader;

    public ATable(CTable _controlleur, String _fileProperties, String _fileAdminProperties) {
        this(_controlleur, _fileProperties, _fileAdminProperties, null);
    }

    public ATable(CTable _controlleur, String _fileProperties, String _fileAdminProperties, Locale _locale) {
        this.controlleur = _controlleur;
        this.value = new Vector();
        try {
            ATable.readAdminProperties(_fileAdminProperties, _locale);
            this.prop = _locale != null ? ResourceBundle.getBundle(_fileProperties, _locale) : ResourceBundle.getBundle(_fileProperties);
            this.title = this.priGetPropertyValue("Titre").trim();
            try {
                this.loader = (ITableInOut)Class.forName(this.priGetPropertyValue("Classe.Chargement")).newInstance();
            }
            catch (Exception ex) {
                System.out.println(loadClassMessage1 + this.priGetPropertyValue("Classe.Chargement") + loadClassMessage2 + this.priGetPropertyValue("Titre"));
            }
            this.nb_col = new Integer(this.priGetPropertyValue("NB_COL"));
            if (this.priGetPropertyValue("Key") != null) {
                this.key = new Integer(this.priGetPropertyValue("Key")) - 1;
            }
            if (this.priGetPropertyValue("AddPossible") != null && this.priGetPropertyValue("AddPossible").compareTo("false") == 0) {
                this.addPossible = false;
            }
            if (this.priGetPropertyValue("SupPossible") != null && this.priGetPropertyValue("SupPossible").compareTo("false") == 0) {
                this.supPossible = false;
            }
            if (this.priGetPropertyValue("DragPossible") != null && this.priGetPropertyValue("DragPossible").compareTo("true") == 0) {
                this.dragPossible = true;
            }
            if (this.priGetPropertyValue("DropPossible") != null && this.priGetPropertyValue("DropPossible").compareTo("true") == 0) {
                this.dropPossible = true;
            }
            if (this.priGetPropertyValue("Editable") != null && this.priGetPropertyValue("Editable").compareTo("false") == 0) {
                this.editable = false;
            }
            if (this.nb_col > 0) {
                this.nameColumn = new String[this.nb_col];
                this.tooltipColumn = new String[this.nb_col];
                this.typeColumn = new String[this.nb_col];
                this.testRegex = new String[this.nb_col];
                this.initValue = new String[this.nb_col];
                this.listValue = new String[this.nb_col][];
                this.champsRequis = new boolean[this.nb_col];
                this.readOnly = new boolean[this.nb_col];
            }
            int i = 1;
            while (i <= this.nb_col) {
                this.nameColumn[i - 1] = this.priGetPropertyValue("" + i + ".Nom");
                this.tooltipColumn[i - 1] = this.priGetPropertyValue("" + i + ".ToolTip");
                this.typeColumn[i - 1] = this.priGetPropertyValue("" + i + ".Type");
                this.testRegex[i - 1] = this.priGetPropertyValue("" + i + ".Test");
                this.champsRequis[i - 1] = this.priGetPropertyValue("" + i + ".Requis") != null && this.priGetPropertyValue("" + i + ".Requis").compareTo("true") == 0;
                this.readOnly[i - 1] = this.priGetPropertyValue("" + i + ".ReadOnly") != null && this.priGetPropertyValue("" + i + ".ReadOnly").compareTo("true") == 0;
                if (this.typeColumn[i - 1].equals(LIST) || this.typeColumn[i - 1].equals(LISTEDITABLE)) {
                    this.listValue[i - 1] = this.priReadStringArray(this.priGetPropertyValue("" + i + ".ValeurPossible"));
                }
                this.initValue[i - 1] = this.priGetPropertyValue("" + i + ".ValeurDefaut");
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static synchronized void readAdminProperties(String _fileProperties, Locale _locale) {
        if (!load) {
            ResourceBundle adminProp = _locale != null ? ResourceBundle.getBundle(_fileProperties, _locale) : ResourceBundle.getBundle(_fileProperties);
            separator = adminProp.getString("Separator").charAt(0);
            erreur = adminProp.getString("Erreur");
            loadClassMessage1 = adminProp.getString("LoadClassMessage1");
            loadClassMessage2 = adminProp.getString("LoadClassMessage2");
            valueRequireMessage = adminProp.getString("ValueRequireMessage");
            doublonMessage = adminProp.getString("DoublonMessage");
            valueNotCorrectMessage = adminProp.getString("ValueNotCorrectMessage");
            deleteMessage = adminProp.getString("DeleteMessage");
        }
    }

    public String toString() {
        StringBuffer strBufferTmp = new StringBuffer();
        strBufferTmp.append("Class ATable : ");
        strBufferTmp.append(" ]");
        return strBufferTmp.toString();
    }

    public void addValue(String[] _value, boolean _refresh) {
        if (_value != null) {
            String[] temp = new String[this.nb_col];
            int i = 0;
            while (i < _value.length && i < this.nb_col) {
                if (_value[i] != null) {
                    temp[i] = _value[i];
                }
                ++i;
            }
            while (i < this.nb_col) {
                temp[i] = "";
                ++i;
            }
            this.value.add(temp);
            if (_refresh) {
                this.controlleur.refresh();
            }
        }
    }

    public boolean isDeletable(int _row) {
        return _row >= 0 && _row < this.value.size() && this.supPossible && this.editable;
    }

    public void addValue(String[] _value) {
        this.addValue(_value, true);
        this.controlleur.refresh();
    }

    public String[] getValue(int i) {
        return (String[])this.value.get(i);
    }

    public String getToolTipText(int _col) {
        if (_col >= 0 && _col < this.nb_col) {
            return this.tooltipColumn[_col];
        }
        return null;
    }

    public int getColumnNumber() {
        return this.nb_col;
    }

    public int getSize() {
        return this.value.size();
    }

    public Object getValueAt(int _row, int _col) {
        if (_row < this.value.size() && _col < this.nb_col) {
            return ((String[])this.value.get(_row))[_col];
        }
        return null;
    }

    public void setValueAt(Object _aValue, int _row, int _col) throws Exception {
        if (this.priValueIsValid((String)_aValue, _row, _col, true)) {
            if (this.addPossible && this.editable && _row == this.value.size()) {
                String[] tmp = new String[this.nb_col];
                tmp[_col] = (String)_aValue;
                this.addValue(tmp, false);
            } else {
                ((String[])this.value.get((int)_row))[_col] = (String)_aValue;
            }
        }
    }

    public String getColumnName(int _column) {
        return this.nameColumn[_column];
    }

    public boolean getAddPossible() {
        return this.addPossible;
    }

    public void setAddPossible(boolean _possible) {
        this.addPossible = _possible;
        this.controlleur.refresh();
    }

    public void load(Object _o) {
        this.value = new Vector();
        this.controlleur.refresh();
        if (this.loader != null) {
            this.loader.load(this, _o);
        }
    }

    public Object[] save() {
        if (this.loader != null) {
            return this.loader.save(this);
        }
        return null;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean _edit) {
        this.editable = _edit;
    }

    public boolean isCellEditable(int _row, int _col) {
        if (this.editable) {
            return !this.readOnly[_col];
        }
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public void delete(int _i) {
        this.value.remove(_i);
        this.controlleur.refresh();
    }

    public String getInitOfColumn(int _col) {
        return this.initValue[_col];
    }

    public String getTypeOfColumn(int _col) {
        return this.typeColumn[_col];
    }

    public String[] getListValueOfColumn(int _col) {
        return this.listValue[_col];
    }

    private String[] priReadStringArray(String _liste) {
        if (_liste != null) {
            Vector<String> temp = new Vector<String>();
            int deb = 0;
            int fin = _liste.indexOf(separator);
            while (fin != -1) {
                temp.add(_liste.substring(deb, fin));
                deb = fin + 1;
                fin = _liste.indexOf(separator, deb);
            }
            if (temp.size() > 0) {
                String[] tt = new String[temp.size()];
                return temp.toArray(tt);
            }
            return null;
        }
        return null;
    }

    boolean valueIsValid(int _row, int _col, boolean _display) throws Exception {
        return this.priValueIsValid(((String[])this.value.get(_row))[_col], _row, _col, _display);
    }

    public boolean validLine(int _row) throws Exception {
        if (_row != -1 && _row != this.getSize()) {
            int i = 0;
            i = 0;
            while (i < this.nb_col && this.valueIsValid(_row, i, true)) {
                ++i;
            }
            return i == this.nb_col;
        }
        return true;
    }

    boolean priValueIsValid(String _value, int _row, int _col, boolean _display) throws Exception {
        boolean ok = true;
        if ((_value == null || _value.length() == 0) && this.champsRequis[_col]) {
            this.priCreateException(valueRequireMessage, _display);
            ok = false;
        }
        if (ok && _col == this.key) {
            int i = 0;
            while (i < _row) {
                if (_value.compareTo(((String[])this.value.get(i))[_col]) == 0) {
                    ok = false;
                }
                ++i;
            }
            int i2 = _row + 1;
            while (i2 < this.value.size() && ok) {
                if (_value.compareTo(((String[])this.value.get(i2))[_col]) == 0) {
                    ok = false;
                }
                ++i2;
            }
            if (!ok) {
                this.priCreateException(doublonMessage, _display);
            }
        }
        if (ok && this.testRegex[_col] != null) {
            if (_value != null) {
                RegularExpression test = new RegularExpression(this.testRegex[_col]);
                Match match = new Match();
                if (!test.matches(_value, match) || match.getCapturedText(0).length() != _value.length()) {
                    this.priCreateException(valueNotCorrectMessage + this.testRegex[_col], _display);
                    ok = false;
                }
            } else {
                this.priCreateException(valueNotCorrectMessage + this.testRegex[_col], _display);
                ok = false;
            }
        }
        return ok;
    }

    private String priGetPropertyValue(String _key) {
        try {
            return this.prop.getString(_key);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isDropPossible() {
        return this.dropPossible;
    }

    public boolean isDragPossible() {
        return this.dragPossible;
    }

    private void priCreateException(String _message, boolean _display) throws ValidException {
        if (_display) {
            throw new ValidException(_message);
        }
    }
}

