/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.regex;

import com.ibm.regex.RangeToken;
import com.ibm.regex.Token;
import java.util.Vector;

class Op {
    static final int DOT = 0;
    static final int CHAR = 1;
    static final int RANGE = 3;
    static final int NRANGE = 4;
    static final int ANCHOR = 5;
    static final int STRING = 6;
    static final int CLOSURE = 7;
    static final int NONGREEDYCLOSURE = 8;
    static final int QUESTION = 9;
    static final int NONGREEDYQUESTION = 10;
    static final int UNION = 11;
    static final int CAPTURE = 15;
    static final int BACKREFERENCE = 16;
    static final int LOOKAHEAD = 20;
    static final int NEGATIVELOOKAHEAD = 21;
    static final int LOOKBEHIND = 22;
    static final int NEGATIVELOOKBEHIND = 23;
    static final int INDEPENDENT = 24;
    static final int MODIFIER = 25;
    static final int CONDITION = 26;
    static final int DOT_CLOSURE = 27;
    static final int RANGE_CLOSURE = 28;
    static final String[] typeNames = new String[]{"DOT", "CHAR", null, "RANGE", "NRANGE", "ANCHOR", "STRING", "CLOSURE", "NONGREEDYCLOSURE", "QUESTION", "NONGREEDYQUESTION", "UNION", null, null, null, "CAPTURE", "BACKREFERENCE", null, null, null, "LOOKAHEAD", "NEGATIVELOOKAHEAD", "LOOKBEHIND", "NEGATIVELOOKBEHIND", "INDEPENDENT", "MODIFIER", "CONDITION", "DOT_CLOSURE", "RANGE_CLOSURE"};
    static int nofinstances = 0;
    static final boolean COUNT = false;
    int type;
    Op next = null;

    static String typeString(int n) {
        return typeNames[n];
    }

    static Op createDot() {
        return new Op(0);
    }

    static CharOp createChar(int n) {
        return new CharOp(1, n);
    }

    static Op createCaseInsensitiveChar(int n) {
        if (n > 65535) {
            return new CharOp(1, n);
        }
        char c = Character.toUpperCase((char)n);
        char c2 = Character.toLowerCase(c);
        if (n == c && c == c2) {
            return new CharOp(1, n);
        }
        RangeToken rangeToken = Token.createRange();
        rangeToken.addRange(n, n);
        rangeToken.addRange(c, c);
        rangeToken.addRange(c2, c2);
        return new RangeOp(3, rangeToken);
    }

    static CharOp createAnchor(int n) {
        return new CharOp(5, n);
    }

    static CharOp createCapture(int n, Op op) {
        CharOp charOp = new CharOp(15, n);
        charOp.next = op;
        return charOp;
    }

    static UnionOp createUnion(int n) {
        return new UnionOp(11, n);
    }

    static CharOp createDotClosure() {
        return new CharOp(27, -1);
    }

    static ChildOp createClosure(int n) {
        return new ModifierOp(7, n, -1);
    }

    static ChildOp createNonGreedyClosure() {
        return new ChildOp(8);
    }

    static ChildOp createQuestion(boolean bl) {
        return new ChildOp(bl ? 10 : 9);
    }

    static RangeOp createRange(Token token) {
        return new RangeOp(3, token);
    }

    static RangeOp createRangeClosure(Token token) {
        return new RangeOp(28, token);
    }

    static ChildOp createLook(int n, Op op, Op op2) {
        ChildOp childOp = new ChildOp(n);
        childOp.setChild(op2);
        childOp.next = op;
        return childOp;
    }

    static CharOp createBackReference(int n) {
        return new CharOp(16, n);
    }

    static StringOp createString(String string) {
        return new StringOp(6, string);
    }

    static ChildOp createIndependent(Op op, Op op2) {
        ChildOp childOp = new ChildOp(24);
        childOp.setChild(op2);
        childOp.next = op;
        return childOp;
    }

    static ModifierOp createModifier(Op op, Op op2, int n, int n2) {
        ModifierOp modifierOp = new ModifierOp(25, n, n2);
        modifierOp.setChild(op2);
        modifierOp.next = op;
        return modifierOp;
    }

    static ConditionOp createCondition(Op op, int n, Op op2, Op op3, Op op4) {
        ConditionOp conditionOp = new ConditionOp(26, n, op2, op3, op4);
        conditionOp.next = op;
        return conditionOp;
    }

    int size() {
        return 0;
    }

    Op elementAt(int n) {
        throw new RuntimeException("Internal Error: type=" + this.type);
    }

    Op getChild() {
        throw new RuntimeException("Internal Error: type=" + this.type);
    }

    void setData(int n) {
        throw new RuntimeException("Internal Error: type=" + this.type);
    }

    int getData() {
        throw new RuntimeException("Internal Error: type=" + this.type);
    }

    int getData2() {
        throw new RuntimeException("Internal Error: type=" + this.type);
    }

    RangeToken getToken() {
        throw new RuntimeException("Internal Error: type=" + this.type);
    }

    String getString() {
        throw new RuntimeException("Internal Error: type=" + this.type);
    }

    public String toString() {
        return Op.typeString(this.type);
    }

    protected Op(int n) {
        this.type = n;
    }

    static class CharOp
    extends Op {
        int charData;

        void setData(int n) {
            this.charData = n;
        }

        int getData() {
            return this.charData;
        }

        public String toString() {
            return super.toString() + "(" + Integer.toHexString(this.charData) + ")";
        }

        CharOp(int n, int n2) {
            super(n);
            this.charData = n2;
        }
    }

    static class UnionOp
    extends Op {
        Vector branches;

        void addElement(Op op) {
            this.branches.addElement(op);
        }

        int size() {
            return this.branches.size();
        }

        Op elementAt(int n) {
            return (Op)this.branches.elementAt(n);
        }

        UnionOp(int n, int n2) {
            super(n);
            this.branches = new Vector(n2);
        }
    }

    static class ChildOp
    extends Op {
        Op child;

        void setChild(Op op) {
            this.child = op;
        }

        Op getChild() {
            return this.child;
        }

        ChildOp(int n) {
            super(n);
        }
    }

    static class ModifierOp
    extends ChildOp {
        int v1;
        int v2;

        int getData() {
            return this.v1;
        }

        int getData2() {
            return this.v2;
        }

        ModifierOp(int n, int n2, int n3) {
            super(n);
            this.v1 = n2;
            this.v2 = n3;
        }
    }

    static class RangeOp
    extends Op {
        Token tok;
        int charData;

        RangeToken getToken() {
            return (RangeToken)this.tok;
        }

        void setData(int n) {
            this.charData = n;
        }

        int getData() {
            return this.charData;
        }

        RangeOp(int n, Token token) {
            super(n);
            this.tok = token;
            this.charData = -1;
        }
    }

    static class StringOp
    extends Op {
        String string;

        String getString() {
            return this.string;
        }

        public String toString() {
            return super.toString() + "(" + this.string.length() + ",'" + this.string + "')";
        }

        StringOp(int n, String string) {
            super(n);
            this.string = string;
        }
    }

    static class ConditionOp
    extends Op {
        int refNumber;
        Op condition;
        Op yes;
        Op no;

        ConditionOp(int n, int n2, Op op, Op op2, Op op3) {
            super(n);
            this.refNumber = n2;
            this.condition = op;
            this.yes = op2;
            this.no = op3;
        }
    }
}

