/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.regex;

import com.ibm.regex.Match;
import com.ibm.regex.ParseException;
import com.ibm.regex.RegularExpression;
import java.text.CharacterIterator;
import java.util.Vector;

public final class REUtil {
    static final int CACHESIZE = 20;
    static RegularExpression[] regexCache = new RegularExpression[20];

    static final int composeFromSurrogates(int n, int n2) {
        return 65536 + (n - 55296 << 10) + n2 - 56320;
    }

    static final boolean isLowSurrogate(int n) {
        return (n & 0xFC00) == 56320;
    }

    static final boolean isHighSurrogate(int n) {
        return (n & 0xFC00) == 55296;
    }

    static final String decomposeToSurrogates(int n) {
        char[] cArray = new char[]{(char)(((n -= 65536) >> 10) + 55296), (char)((n & 0x3FF) + 56320)};
        return new String(cArray);
    }

    static final String substring(CharacterIterator characterIterator, int n, int n2) {
        char[] cArray = new char[n2 - n];
        int n3 = 0;
        while (n3 < cArray.length) {
            cArray[n3] = characterIterator.setIndex(n3 + n);
            ++n3;
        }
        return new String(cArray);
    }

    static final int getOptionValue(int n) {
        int n2 = 0;
        switch (n) {
            case 105: {
                n2 = 2;
                break;
            }
            case 73: {
                n2 = 2048;
                break;
            }
            case 109: {
                n2 = 8;
                break;
            }
            case 115: {
                n2 = 4;
                break;
            }
            case 120: {
                n2 = 16;
                break;
            }
            case 117: {
                n2 = 32;
                break;
            }
            case 119: {
                n2 = 64;
                break;
            }
            case 70: {
                n2 = 256;
                break;
            }
            case 72: {
                n2 = 128;
                break;
            }
            case 88: {
                n2 = 512;
                break;
            }
            case 80: {
                n2 = 4096;
                break;
            }
            case 44: {
                n2 = 1024;
                break;
            }
        }
        return n2;
    }

    static final int parseOptions(String string) throws ParseException {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = REUtil.getOptionValue(string.charAt(n2));
            if (n3 == 0) {
                throw new ParseException("Unknown Option: " + string.substring(n2), -1);
            }
            n |= n3;
            ++n2;
        }
        return n;
    }

    static final String createOptionString(int n) {
        StringBuffer stringBuffer = new StringBuffer(9);
        if ((n & 0x100) != 0) {
            stringBuffer.append('F');
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append('H');
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append('X');
        }
        if ((n & 2) != 0) {
            stringBuffer.append('i');
        }
        if ((n & 0x800) != 0) {
            stringBuffer.append('I');
        }
        if ((n & 8) != 0) {
            stringBuffer.append('m');
        }
        if ((n & 4) != 0) {
            stringBuffer.append('s');
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append('u');
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append('w');
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append('x');
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append('P');
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append(',');
        }
        return stringBuffer.toString().intern();
    }

    static String stripExtendedComment(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        block0: while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '\t' || c == '\n' || c == '\f' || c == '\r' || c == ' ') continue;
            if (c == '#') {
                while (n2 < n) {
                    if ((c = string.charAt(n2++)) == '\r' || c == '\n') continue block0;
                }
                continue;
            }
            if (c == '\\' && n2 < n) {
                char c2 = string.charAt(n2);
                if (c2 == '#' || c2 == '\t' || c2 == '\n' || c2 == '\f' || c2 == '\r' || c2 == ' ') {
                    stringBuffer.append(c2);
                    ++n2;
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(c2);
                ++n2;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] var0) {
        var1_1 = null;
        try {
            var2_2 = "";
            var3_5 = null;
            var4_7 = 0;
            while (var4_7 < var0.length) {
                if (var0[var4_7].length() == 0 || var0[var4_7].charAt(0) != '-') {
                    if (var1_1 == null) {
                        var1_1 = var0[var4_7];
                    } else if (var3_5 == null) {
                        var3_5 = var0[var4_7];
                    } else {
                        System.err.println("Unnecessary: " + var0[var4_7]);
                    }
                } else if (var0[var4_7].equals("-i")) {
                    var2_2 = var2_2 + "i";
                } else if (var0[var4_7].equals("-m")) {
                    var2_2 = var2_2 + "m";
                } else if (var0[var4_7].equals("-s")) {
                    var2_2 = var2_2 + "s";
                } else if (var0[var4_7].equals("-u")) {
                    var2_2 = var2_2 + "u";
                } else if (var0[var4_7].equals("-w")) {
                    var2_2 = var2_2 + "w";
                } else if (var0[var4_7].equals("-X")) {
                    var2_2 = var2_2 + "X";
                } else if (var0[var4_7].equals("-,")) {
                    var2_2 = var2_2 + ",";
                } else {
                    System.err.println("Unknown option: " + var0[var4_7]);
                }
                ++var4_7;
            }
            var4_8 = new RegularExpression(var1_1, var2_2);
            System.out.println("RegularExpression: " + var4_8);
            System.out.println("\tMinimum matching length: " + var4_8.getMinLength());
            System.out.println("\tMaximum matching length: " + var4_8.getMaxLength());
            var5_10 = new Match();
            var4_8.matches(var3_5, var5_10);
            System.out.println("Result:");
            var6_12 = 0;
            while (var6_12 < var5_10.getNumberOfGroups()) {
                if (var6_12 == 0) {
                    System.out.print("Matched range for the whole pattern: ");
                } else {
                    System.out.print("[" + var6_12 + "]: ");
                }
                if (var5_10.getBeginning(var6_12) < 0) {
                    System.out.println("-1");
                } else {
                    System.out.print(var5_10.getBeginning(var6_12) + ", " + var5_10.getEnd(var6_12) + ", ");
                    System.out.println("\"" + var5_10.getCapturedText(var6_12) + "\"");
                }
                ++var6_12;
            }
            return;
        }
        catch (ParseException var2_3) {
            if (var1_1 == null) {
                var2_3.printStackTrace();
                return;
            }
            System.err.println("com.ibm.regex.ParseException: " + var2_3.getMessage());
            var3_6 = "        ";
            System.err.println(var3_6 + var1_1);
            var4_9 = var2_3.getLocation();
            if (var4_9 < 0) return;
            System.err.print(var3_6);
            var5_11 = 0;
            ** while (var5_11 < var4_9)
        }
lbl-1000:
        // 1 sources

        {
            System.err.print("-");
            ++var5_11;
            continue;
        }
lbl77:
        // 1 sources

        System.err.println("^");
        return;
        catch (Exception var2_4) {
            var2_4.printStackTrace();
        }
    }

    public static RegularExpression createRegex(String string, String string2) throws ParseException {
        RegularExpression regularExpression = null;
        int n = REUtil.parseOptions(string2);
        RegularExpression[] regularExpressionArray = regexCache;
        synchronized (regularExpressionArray) {
            int n2 = 0;
            while (n2 < 20) {
                RegularExpression regularExpression2 = regexCache[n2];
                if (regularExpression2 == null) {
                    n2 = -1;
                    break;
                }
                if (regularExpression2.equals(string, n)) {
                    regularExpression = regularExpression2;
                    break;
                }
                ++n2;
            }
            if (regularExpression != null) {
                if (n2 != 0) {
                    System.arraycopy(regexCache, 0, regexCache, 1, n2);
                    REUtil.regexCache[0] = regularExpression;
                }
            } else {
                regularExpression = new RegularExpression(string, string2);
                System.arraycopy(regexCache, 0, regexCache, 1, 19);
                REUtil.regexCache[0] = regularExpression;
            }
        }
        return regularExpression;
    }

    public static boolean matches(String string, String string2) throws ParseException {
        return REUtil.createRegex(string, null).matches(string2);
    }

    public static boolean matches(String string, String string2, String string3) throws ParseException {
        return REUtil.createRegex(string, string2).matches(string3);
    }

    public static String quoteMeta(String string) {
        int n = string.length();
        StringBuffer stringBuffer = null;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (".*+?{[()|\\^$".indexOf(c) >= 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n2 + (n - n2) * 2);
                    if (n2 > 0) {
                        stringBuffer.append(string.substring(0, n2));
                    }
                }
                stringBuffer.append('\\');
                stringBuffer.append(c);
            } else if (stringBuffer != null) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer != null ? stringBuffer.toString() : string;
    }

    public static int unicodeLength(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (REUtil.isHighSurrogate(c) && n3 + 1 < n && REUtil.isLowSurrogate(string.charAt(n3 + 1))) {
                ++n3;
            }
            ++n2;
            ++n3;
        }
        return n2;
    }

    public static String substitute(String string, String string2, String string3, String string4) {
        RegularExpression regularExpression = REUtil.createRegex(string, REUtil.omit_g(string3));
        Object var5_5 = null;
        boolean bl = string3.indexOf(103) >= 0;
        return REUtil.substitute(regularExpression, string2, bl, string4);
    }

    public static String substitute(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        if (string.charAt(n3) == 's') {
            // empty if block
        }
        int n4 = ++n3;
        char c = string.charAt(n4);
        int n5 = ++n3;
        StringBuffer stringBuffer = null;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 == '\\') {
                if ((n = string.charAt(++n3)) == c) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n2);
                        stringBuffer.append(string.substring(n5, n3 - 1));
                    }
                    stringBuffer.append(c);
                } else if (stringBuffer != null) {
                    stringBuffer.append('\\');
                    stringBuffer.append((char)n);
                }
            } else {
                if (c2 == c) break;
                if (stringBuffer != null) {
                    stringBuffer.append(c2);
                }
            }
            ++n3;
        }
        if (n3 >= n2) {
            throw new ParseException("No delimiter after the pattern.", n3);
        }
        String string3 = stringBuffer == null ? string.substring(n5, n3) : new String(stringBuffer);
        n = ++n3;
        StringBuffer stringBuffer2 = null;
        while (n3 < n2) {
            char c3 = string.charAt(n3);
            if (c3 == '\\') {
                char c4;
                if ((c4 = string.charAt(++n3)) == c) {
                    if (stringBuffer2 == null) {
                        if (stringBuffer == null) {
                            stringBuffer2 = new StringBuffer(n2);
                        } else {
                            stringBuffer2 = stringBuffer;
                            stringBuffer2.setLength(0);
                        }
                        stringBuffer2.append(string.substring(n5, n3 - 1));
                    }
                    stringBuffer2.append(c);
                } else if (stringBuffer2 != null) {
                    stringBuffer2.append('\\');
                    stringBuffer2.append(c4);
                }
            } else {
                if (c3 == c) break;
                if (stringBuffer2 != null) {
                    stringBuffer2.append(c3);
                }
            }
            ++n3;
        }
        if (n3 >= n2) {
            throw new ParseException("No delimiter after the replacement text.", n3);
        }
        String string4 = stringBuffer2 == null ? string.substring(n, n3) : new String(stringBuffer2);
        String string5 = string.substring(++n3);
        return REUtil.substitute(string3, string4, string5, string2);
    }

    public static String substitute(RegularExpression regularExpression, String string, boolean bl, String string2) {
        StringBuffer stringBuffer = null;
        Match match = new Match();
        Vector vector = REUtil.parseReplacement(string);
        if (bl) {
            int n = 0;
            int n2 = 0;
            int n3 = string2.length();
            while (regularExpression.matches(string2, 0, n, n3, match)) {
                int n4 = match.getBeginning(0);
                int n5 = match.getEnd(0);
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(string2.substring(n2, n4));
                REUtil.subst(stringBuffer, vector, match);
                n2 = n5;
                n = n5;
                if (n4 != n5) continue;
                ++n;
            }
            if (stringBuffer != null && n2 < n3) {
                stringBuffer.append(string2.substring(n2));
            }
        } else if (regularExpression.matches(string2, match)) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string2.substring(0, match.getBeginning(0)));
            REUtil.subst(stringBuffer, vector, match);
            stringBuffer.append(string2.substring(match.getEnd(0)));
        }
        return stringBuffer == null ? string2 : new String(stringBuffer);
    }

    private static String omit_g(String string) {
        StringBuffer stringBuffer = null;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == 'g') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.length());
                    stringBuffer.append(string.substring(0, n));
                }
            } else if (stringBuffer != null) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer == null ? string : new String(stringBuffer);
    }

    private static void subst(StringBuffer stringBuffer, Vector vector, Match match) {
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof String) {
                stringBuffer.append((String)e);
            } else if (e instanceof Integer) {
                String string = match.getCapturedText((Integer)e);
                if (string != null) {
                    stringBuffer.append(string);
                }
            } else {
                throw new RuntimeException("Internal Error: Unknown type: " + e.getClass());
            }
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Vector parseReplacement(String string) {
        int n;
        int n2 = string.length();
        Vector<Object> vector = new Vector<Object>();
        int n3 = 0;
        while ((n = REUtil.indexOfBSorDollar(string, n3)) >= 0) {
            vector.addElement(string.substring(n3, n));
            n3 = n;
            char c = string.charAt(n3);
            if (++n3 >= n2) {
                char[] cArray = new char[]{c};
                vector.addElement(new String(cArray));
            } else if (c == '\\') {
                char c2 = string.charAt(n3);
                if (c2 == '\\') {
                    vector.addElement("\\");
                } else if (c2 == '$') {
                    vector.addElement("$");
                } else {
                    if ('1' > c2 || c2 > '9') throw new ParseException("Unknown sequence: \\" + (char)c2, n3);
                    vector.addElement(new Integer(c2 - 48));
                }
            } else {
                char c3 = string.charAt(n3);
                if ('1' <= c3 && c3 <= '9') {
                    vector.addElement(new Integer(c3 - 48));
                } else if (c3 == '{') {
                    int n4 = n3 - 1;
                    int n5 = 0;
                    char c4 = '\u0000';
                    while (++n3 < n2) {
                        c4 = string.charAt(n3);
                        if (c4 < '0' || '9' < c4) break;
                        n5 = n5 * 10 + c4 - 48;
                    }
                    if (n3 >= n2 || n5 == 0 || c4 != '}') {
                        vector.addElement(string.substring(n4, n3--));
                    } else {
                        vector.addElement(new Integer(n5));
                    }
                } else {
                    vector.addElement("$");
                }
            }
            ++n3;
        }
        vector.addElement(string.substring(n3));
        return vector;
    }

    public static String quoteReplacement(String string) {
        int n = string.length();
        StringBuffer stringBuffer = null;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\\' || c == '$') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n2 + (n - n2) * 2);
                    if (n2 > 0) {
                        stringBuffer.append(string.substring(0, n2));
                    }
                }
                stringBuffer.append('\\');
                stringBuffer.append(c);
            } else if (stringBuffer != null) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer != null ? stringBuffer.toString() : string;
    }

    private static int indexOfBSorDollar(String string, int n) {
        int n2 = string.length();
        int n3 = -1;
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '\\' || c == '$') {
                n3 = n;
                break;
            }
            ++n;
        }
        return n3;
    }

    public static String[] split(String string, String string2, String string3, int n) {
        if (n == 0) {
            return new String[0];
        }
        RegularExpression regularExpression = REUtil.createRegex(string, string2);
        return REUtil.split(regularExpression, string3, n);
    }

    public static String[] split(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = 0;
        if (string.charAt(n3) == 'm') {
            // empty if block
        }
        int n4 = ++n3;
        char c = string.charAt(n4);
        int n5 = ++n3;
        StringBuffer stringBuffer = null;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 == '\\') {
                char c3;
                if ((c3 = string.charAt(++n3)) == c) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n2);
                        stringBuffer.append(string.substring(n5, n3 - 1));
                    }
                    stringBuffer.append(c);
                } else if (stringBuffer != null) {
                    stringBuffer.append('\\');
                    stringBuffer.append(c3);
                }
            } else {
                if (c2 == c) break;
                if (stringBuffer != null) {
                    stringBuffer.append(c2);
                }
            }
            ++n3;
        }
        String string3 = stringBuffer != null ? new String(stringBuffer) : (n3 >= n2 ? string.substring(n5) : string.substring(n5, n3));
        String string4 = "";
        if (++n3 < n2) {
            string4 = string.substring(n3);
        }
        return REUtil.split(string3, string4, string2, n);
    }

    public static String[] split(String string, String string2) {
        return REUtil.split(string, string2, -1);
    }

    public static String[] split(RegularExpression regularExpression, String string, int n) {
        int n2;
        if (n == 0) {
            return new String[0];
        }
        int n3 = n < 0 ? Integer.MAX_VALUE : n - 1;
        Vector<String> vector = new Vector<String>();
        int n4 = string.length();
        Match match = new Match();
        boolean bl = regularExpression.getNumberOfGroups() > 1;
        int n5 = 0;
        int n6 = 0;
        while (n3-- > 0 && regularExpression.matches(string, n5, n4, match)) {
            int n7 = match.getBeginning(0);
            n2 = match.getEnd(0);
            if (n6 == n7 && n7 == n2) {
                ++n5;
                continue;
            }
            vector.addElement(string.substring(n6, n7));
            if (bl) {
                vector.addElement(match.getCapturedText(1));
            }
            n5 = n2;
            n6 = n2;
        }
        if (n6 <= n4) {
            vector.addElement(string.substring(n6));
        }
        String[] stringArray = new String[vector.size()];
        n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    static void dumpString(String string) {
        int n = 0;
        while (n < string.length()) {
            System.out.print("U+");
            System.out.print(Integer.toHexString(string.charAt(n)));
            System.out.print(" ");
            ++n;
        }
        System.out.println();
    }

    private REUtil() {
    }
}

