/*
 * Decompiled with CFR 0.152.
 */
package perenono.pac.easytable;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import perenono.pac.easytable.Table;

public class EcouteurDragAndDrop
implements DropTargetListener,
DragGestureListener,
DragSourceListener {
    public Table table;

    private EcouteurDragAndDrop() {
    }

    public EcouteurDragAndDrop(Table _table) {
        this.table = _table;
    }

    public void dragEnter(DropTargetDragEvent event) {
    }

    public void dragExit(DropTargetEvent event) {
    }

    public void dragOver(DropTargetDragEvent event) {
    }

    public void dropActionChanged(DropTargetDragEvent event) {
    }

    public void drop(DropTargetDropEvent event) {
        try {
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrop(3);
                List s = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (s == null || s.size() > 0) {
                    // empty if block
                }
                event.getDropTargetContext().dropComplete(true);
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                event.acceptDrop(3);
                String s = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (s != null) {
                    this.table.addLine(this.priReadStringArray(s, ','));
                }
                event.getDropTargetContext().dropComplete(true);
            } else {
                event.rejectDrop();
            }
        }
        catch (IOException exception) {
            System.err.println("Exception" + exception.getMessage());
            event.rejectDrop();
        }
        catch (UnsupportedFlavorException ufException) {
            System.err.println("Exception" + ufException.getMessage());
            event.rejectDrop();
        }
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        String[] list = this.table.getLine();
        StringBuffer temp = new StringBuffer();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                if (list[i] != null) {
                    temp.append(list[i]).append(',');
                } else {
                    temp.append(',');
                }
                ++i;
            }
            if (temp.length() > 0) {
                temp.setLength(temp.length() - 1);
            }
            e.startDrag(DragSource.DefaultCopyDrop, new StringSelection(temp.toString()), this);
        }
    }

    private String[] priReadStringArray(String _liste, char _sep) {
        if (_liste != null) {
            Vector<String> temp = new Vector<String>();
            int deb = 0;
            int fin = _liste.indexOf(_sep);
            while (fin != -1) {
                temp.add(_liste.substring(deb, fin));
                deb = fin + 1;
                fin = _liste.indexOf(_sep, deb);
            }
            if (temp.size() > 0) {
                if (deb < _liste.length()) {
                    temp.add(_liste.substring(deb));
                }
                String[] tt = new String[temp.size()];
                return temp.toArray(tt);
            }
            return null;
        }
        return null;
    }
}

