/*
 * Decompiled with CFR 0.152.
 */
package perenono.pac.easytable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import perenono.pac.easytable.CTable;
import perenono.pac.easytable.EcouteurDragAndDrop;
import perenono.pac.easytable.IControlleurListener;
import perenono.pac.easytable.ValidException;

public class Table
extends JPanel
implements IControlleurListener {
    public CTable controlleur;
    private JTable table;
    private JPopupMenu popup;
    private AListSelectionModel listSelectionModel;

    private Table() {
    }

    public Table(CTable _controlleur, String _title) {
        this.controlleur = _controlleur;
        this.controlleur.addPrivateListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(_title));
        ATableModel _dataModel = new ATableModel();
        this.setToolTipText("");
        this.table = new AdaptTable();
        this.table.setModel(_dataModel);
        this.table.setSelectionModel(this.getSelectionModel());
        this.table.addMouseListener(new TablePopup());
        this.add((Component)new JScrollPane(this.table), "Center");
        int i = 0;
        while (i < _dataModel.getColumnCount()) {
            TableColumn sportColumn = this.table.getColumnModel().getColumn(i);
            JComboBox combo = this.getActionColumn(i);
            if (combo != null) {
                sportColumn.setCellEditor(new DefaultCellEditor(combo));
            }
            ++i;
        }
        this.popup = new JPopupMenu();
        JMenuItem supp = new JMenuItem("Supprimer");
        supp.addActionListener(new ActionEcouteur());
        this.popup.add(supp);
        EcouteurDragAndDrop dnd = new EcouteurDragAndDrop(this);
        if (this.controlleur.isDropPossible()) {
            new DropTarget(this, 3, dnd);
            new DropTarget(this.table, 3, dnd);
        }
        if (this.controlleur.isDragPossible()) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this.table, 3, dnd);
        }
    }

    public void refresh() {
        try {
            this.table.updateUI();
            this.table.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addLine(String[] _params) {
        this.controlleur.addLine(_params);
    }

    public String[] getLine() {
        int pos = this.table.getSelectedRow();
        if (pos >= 0) {
            return this.controlleur.getLine(pos);
        }
        return null;
    }

    public AListSelectionModel getSelectionModel() {
        if (this.listSelectionModel == null) {
            this.listSelectionModel = new AListSelectionModel();
        }
        return this.listSelectionModel;
    }

    public JComboBox getActionColumn(int _col) {
        String[] listValue;
        String type = this.controlleur.getTypeOfColumn(_col);
        if ((type.equals("List") || type.equals("ListEditable")) && (listValue = this.controlleur.getListValueOfColumn(_col)) != null) {
            JComboBox<String> temp = new JComboBox<String>(listValue);
            temp.setSelectedItem(this.controlleur.getInitOfColumn(_col));
            if (type.equals("ListEditable")) {
                temp.setEditable(true);
            }
            return temp;
        }
        return null;
    }

    public class ATableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return Table.this.controlleur.getColumnNumber();
        }

        public String getColumnName(int _column) {
            return Table.this.controlleur.getColumnName(_column);
        }

        public int getRowCount() {
            int size = Table.this.controlleur.getSize();
            if (Table.this.controlleur.isAddPossible() && Table.this.controlleur.isEditable()) {
                return size + 1;
            }
            return size;
        }

        public Object getValueAt(int _row, int _col) {
            return Table.this.controlleur.getValueAt(_row, _col);
        }

        public boolean isCellEditable(int _row, int _col) {
            return Table.this.controlleur.isCellEditable(_row, _col);
        }

        public void setValueAt(Object _aValue, int _row, int _col) {
            try {
                Table.this.controlleur.setValueAt(_aValue, _row, _col);
            }
            catch (ValidException ex) {
                JOptionPane.showOptionDialog(null, ex.getMessage(), "erreur", -1, 0, null, null, null);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public class AListSelectionModel
    extends DefaultListSelectionModel {
        public AListSelectionModel() {
            this.setSelectionMode(0);
        }

        public void setSelectionInterval(int _first, int _last) {
            try {
                int old = this.getMinSelectionIndex();
                int nb_col = Table.this.controlleur.getColumnNumber();
                if (old != _first) {
                    if (Table.this.controlleur.validLine(old)) {
                        super.setSelectionInterval(_first, _last);
                    } else {
                        JOptionPane.showOptionDialog(null, "ligne incorrect", "erreur", -1, 0, null, null, null);
                    }
                } else {
                    System.out.println("select interval2");
                    super.setSelectionInterval(_first, _last);
                }
            }
            catch (ValidException ex) {
                JOptionPane.showOptionDialog(null, ex.getMessage(), "erreur", -1, 0, null, null, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public class AdaptTable
    extends JTable {
        public String getToolTipText(MouseEvent e) {
            int column = Table.this.table.columnAtPoint(e.getPoint());
            return Table.this.controlleur.getToolTipText(column);
        }
    }

    private class ActionEcouteur
    implements ActionListener {
        private ActionEcouteur() {
        }

        public void actionPerformed(ActionEvent e) {
            Table.this.controlleur.delete(Table.this.table.getSelectedRow());
        }
    }

    public class TablePopup
    extends MouseAdapter {
        public void mouseReleased(MouseEvent e) {
            if (e.isShiftDown() || e.isControlDown() || e.isAltDown()) {
                return;
            }
            if (e.isMetaDown()) {
                Point point = e.getPoint();
                int row = Table.this.table.rowAtPoint(point);
                Table.this.table.setRowSelectionInterval(row, row);
                if (Table.this.controlleur.isDeletable(row)) {
                    Table.this.popup.show(Table.this.table, point.x, point.y);
                }
            }
        }
    }
}

