/****************************************************
* auteur  : Nol Perez			 	*
* date    : 21 septembre 2002			*
* fichier : MembreLoader.java			*
****************************************************/
/*
 * Rvisions :
 *
 * $Id$
 *
 * $Log$
 */

package tableloader;

import perenono.pac.easytable.ITableInOut;
import perenono.pac.easytable.ATable;

import noyau.structure.JNClass;
import noyau.structure.JNClassMembre;

/**
  * <br> 
  * s'occupe de charger les valeurs des parametres d'une methode dans la table
  * 
  * @author Nol Perez
  */ 
public class MembreLoader implements ITableInOut
{

	//----------------------------------------------------------------------------
	/** 
	  * Constructeur par dfaut de la classe MethodeLoader
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public MembreLoader(){}
	
	//----------------------------------------------------------------------------
	/** 
	  * Methode permettant de decharger les donnes utiles contenues dans _o  l'intrieur de la table
	  *
	  * @param _control conteneur des donnes affiches
	  * @param _o donne  charger ( dans ce cas, cela doit tre une instance de "JNClass" )
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public void load(ATable _control, Object _o)
	{
		if(_o !=null && _o instanceof JNClass)
		{
			JNClassMembre[] membresTemp = (JNClassMembre[])((JNClass)_o).getMembres();
			int size = membresTemp.length;
			for(int i=0; i<size;i++)
			{
				String[] temp = new String[4];
				temp[0] = membresTemp[i].getPortee();
				temp[1] = membresTemp[i].getType();
				temp[2] = membresTemp[i].getNom();
				temp[3] = membresTemp[i].getComment();
				
				_control.addValue(temp);
			}
		}
		else if(_o!=null) System.out.println("ce n'est pas un JNClass "+_o);
	}
	
	//----------------------------------------------------------------------------
	/** 
	  * Methode permettant de rcuperer les donnes de la table
	  *
	  * @param _control conteneur des donnes affiches
	  * @return un tableau  deux dimensions contenant les noms des paramtres ainsi que les commentaires et type associs
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public Object[] save(ATable _control)
	{
		int size = _control.getSize();
		
		JNClassMembre[] param = new JNClassMembre[size];
		for(int i=0;i<size;i++)
			{
			String[] temp = _control.getValue(i);
			param[i] = new JNClassMembre(temp[0],temp[1],temp[2],temp[3]);
			}
		return param;
	}

}