/****************************************************
* auteur  : Nol Perez			 	*
* date    : 20 aot 2002			*
* fichier : ATable.java			 	*
****************************************************/
/*
 * Rvisions :
 *
 * $Id$
 *
 * $Log$
 */

package perenono.pac.easytable;

import java.io.FileInputStream;
import java.util.Vector;
import java.util.Properties;
import java.util.Locale;
import java.util.ResourceBundle;

import com.ibm.regex.*;

/**
  * partie abstraction de la table
  *
  * @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
  * @see this class is distributed under LGPL licence
  */
public class ATable
{
	/**
	* identifiant d'une colonne de type List
	*/
	public final static String LIST = "List";
	/**
	* identifiant d'une colonne de type ListEditable
	*/
	public final static String LISTEDITABLE = "ListEditable";
	/**
	* identifiant d'une colonne de type String
	*/
	public final static String STRING = "String";
	
	/**
	* reference vers le controlleur du composant
	*/
	private CTable controlleur;

	/**
	* nombre de colonne visible
	*/
	private int nb_col;
	/**
	* numero de la colonne servant de cl ( si -1 aucune cl )
	*/
	private int key=-1;
	/**
	* titre de la table ( si null on encadre pas la table )
	*/
	private String title;
	/**
	* true si on peut entrer ses propres valeurs
	*/
	private boolean addPossible = true;
	/**
	* true si on peut supprimer une ligne
	*/
	private boolean supPossible = true;
	/**
	* true si les valeurs charges peuvent tre changes
	*/
	private boolean editable = true;
	/**
	* fichier de properties de la table
 	*/
	private	ResourceBundle prop;
	/**
	* true si la table peut transferer des lignes par un gliss
	*/
	private boolean dragPossible = false;
	/**
	* true si la table peut recuperer des lignes par un dpos
	*/
	private boolean dropPossible = false;
	/**
	* liste des noms des colonnes
	*/
	private String[] nameColumn;
	/**
	* liste des textes de rollback des colonnes
	*/
	private String[] tooltipColumn;
	/**
	* liste des types des colonnes
	*/
	private String[] typeColumn; 
	/**
	* liste des valeurs par dfauts des colonnes
	*/
	private String[] initValue;
	/**
	* liste des expressions auquelles doivent se conformer les saisies par colonne
	*/
	private String[] testRegex;
	/**
	* liste des champs requis
	*/
	private boolean[] champsRequis;
	/**
	* liste des champs en lecture seul
	*/
	private boolean[] readOnly;
	/**
	* liste des valeurs possibles par colonne
	*/
	private String[][] listValue;
	/**
	* liste des valeurs de la table
	*/
	private Vector value;

	/**
	* indique si les valeurs ont t charges
	*/
	public static boolean load = false;
	/**
	* separateur utilis dans les fichiers properties
	*/
	public static char separator;
	/**
	* titre pour les fentres d'erreurs
	*/
	public static String erreur;
	/**
	* message d'erreur de chargement de classe ( partie 1 )
	*/
	public static String loadClassMessage1;
	/**
	* message d'erreur de chargement de classe ( partie 2 )
	*/
	public static String loadClassMessage2;
	/**
	* message d'erreur lorsqu'un champs requi n'est pas rempli
	*/
	public static String valueRequireMessage;
	/**
	* message emis lorsqu'il existe un doublon sur la colonne servant de cl
	*/
	public static String doublonMessage;
	/**
	* message emis si la valeur saisie ne corespond pas au pattern indiqu
	*/
	public static String valueNotCorrectMessage;
	/**
	* label du bouton de suppression
	*/
	public static String deleteMessage;

	/**
	* permet le chargement et dechargement des donnes ( fourni par l'utilisateur / nom de la classe indiqu dans le fichier de proprit )
	*/
	private ITableInOut loader;
	
	//----------------------------------------------------------------------------
	/** 
	  * Constructeur par dfaut de la classe ATable, il parse le fichier de properties associ et charge les valeurs
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public ATable(CTable _controlleur, String _fileProperties, String _fileAdminProperties)
	{
		this(_controlleur, _fileProperties, _fileAdminProperties, null);
	}
	
	//----------------------------------------------------------------------------
	/** 
	  * Constructeur par dfaut de la classe ATable, il parse le fichier de properties associ et charge les valeurs
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public ATable(CTable _controlleur, String _fileProperties, String _fileAdminProperties, Locale _locale)
	{
		this.controlleur = _controlleur;
		//j'initialise le vecteur contenant les donnes
		value = new Vector();
		
		try{
			readAdminProperties(_fileAdminProperties, _locale);
		
			//accs au fichier de proprits
			if(_locale!=null) prop = ResourceBundle.getBundle(_fileProperties, _locale);
			else prop = ResourceBundle.getBundle(_fileProperties);
			
			title = priGetPropertyValue("Titre").trim();
			
			//recuperation de la classe de chargement et creation d'une instance de celle-ci
			try{
				loader = (ITableInOut)((Class.forName(priGetPropertyValue("Classe.Chargement"))).newInstance());
			}catch(Exception ex)
			{
				System.out.println(loadClassMessage1+priGetPropertyValue("Classe.Chargement")+loadClassMessage2+priGetPropertyValue("Titre"));
			}
			
			//rcupration des donnes gnriques
			nb_col = (new Integer(priGetPropertyValue("NB_COL"))).intValue();
			if(priGetPropertyValue("Key") !=null) key = (new Integer(priGetPropertyValue("Key"))).intValue()-1;
			if(priGetPropertyValue("AddPossible")!=null && (priGetPropertyValue("AddPossible")).compareTo("false")==0 ) addPossible = false;
			if(priGetPropertyValue("SupPossible")!=null && (priGetPropertyValue("SupPossible")).compareTo("false")==0 ) supPossible = false;
			if(priGetPropertyValue("DragPossible")!=null && (priGetPropertyValue("DragPossible")).compareTo("true")==0 ) dragPossible = true;
			if(priGetPropertyValue("DropPossible")!=null && (priGetPropertyValue("DropPossible")).compareTo("true")==0 ) dropPossible = true;
			if(priGetPropertyValue("Editable")!=null && (priGetPropertyValue("Editable")).compareTo("false")==0 ) editable = false;
	
			if(nb_col>0)
			{
				//initialisation des tables de valeurs
				nameColumn = new String[nb_col];
				tooltipColumn = new String[nb_col];
				typeColumn = new String[nb_col];
				testRegex = new String[nb_col];
				initValue = new String[nb_col];
				listValue = new String[nb_col][];
				champsRequis = new boolean[nb_col];
				readOnly = new boolean[nb_col];
			}
			
			//remplissage des tables avec les valeurs du properties
			for(int i=1;i<=nb_col;i++)
			{
				nameColumn[i-1] = priGetPropertyValue(""+i+".Nom");
				tooltipColumn[i-1] = priGetPropertyValue(""+i+".ToolTip");
				typeColumn[i-1] = priGetPropertyValue(""+i+".Type");
				testRegex[i-1] = priGetPropertyValue(""+i+".Test");
				if(priGetPropertyValue(""+i+".Requis")!=null && (priGetPropertyValue(""+i+".Requis")).compareTo("true")==0)
				{
					champsRequis[i-1]=true;
				}
				else
				{
					champsRequis[i-1]=false;
				}
				
				if(priGetPropertyValue(""+i+".ReadOnly")!=null && (priGetPropertyValue(""+i+".ReadOnly")).compareTo("true")==0)
				{
					readOnly[i-1] = true;
				}
				else
				{
					readOnly[i-1] = false;
				}	
				if(typeColumn[i-1].equals("List") || typeColumn[i-1].equals("ListEditable"))
				{
					listValue[i-1] = priReadStringArray( priGetPropertyValue(""+i+".ValeurPossible") );				
				}
				initValue[i-1] = priGetPropertyValue(""+i+".ValeurDefaut");
			}
		}catch(Exception ex){ex.printStackTrace();}	
	}

	//----------------------------------------------------------------------------
	/** 
	  * fonction permettant de lire les infos d'administration contenues dans le fichier properties
	  *
	  * @param _fileProperties nom du properties
	  * @param _locale locale pour l'internationalisation
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	private static synchronized void readAdminProperties(String _fileProperties, Locale _locale)
	{
		if(!load)
		{
			ResourceBundle adminProp;
			if(_locale!=null) adminProp = ResourceBundle.getBundle(_fileProperties, _locale);
			else adminProp = ResourceBundle.getBundle(_fileProperties);

			separator = (adminProp.getString("Separator")).charAt(0);
			erreur = adminProp.getString("Erreur");
			loadClassMessage1 = adminProp.getString("LoadClassMessage1");
			loadClassMessage2 = adminProp.getString("LoadClassMessage2");
			valueRequireMessage = adminProp.getString("ValueRequireMessage");
			doublonMessage = adminProp.getString("DoublonMessage");
			valueNotCorrectMessage = adminProp.getString("ValueNotCorrectMessage");
			deleteMessage = adminProp.getString("DeleteMessage");
		}
	}
	
	public String toString()
	{
		StringBuffer strBufferTmp = new StringBuffer();
		strBufferTmp.append("Class ATable : ");

		strBufferTmp.append(" ]");
		return strBufferTmp.toString();
	}

	/**
	* ajoute une ligne  la table ( s'il manque des champs, on rajoute des champs vides )
	*
	* @param _value tableau contenant les valeurs
	* @param _refresh true s'il faut rafrachir
	* @author Nol Perez
	*/
	public void addValue(String[] _value, boolean _refresh)
	{
		if(_value!=null)
		{
			String[] temp = new String[nb_col];
			int i=0;
			for(;i<_value.length && i<nb_col;i++)
			{
				if(_value[i]!=null)
					temp[i] = _value[i];
			}
			for(;i<nb_col;i++)
			{
				temp[i] = "";
			}
			this.value.add(temp);

			if(_refresh) controlleur.refresh();
		}
	}
	
	/**
	* test si la ligne peut tre supprime
	*
	* @param _row ligne  tester
	* @return true si on peut la supprimer
	* @author Nol Perez
	*/
	public boolean isDeletable(int _row)
	{
		if(_row>=0 && _row<value.size() && supPossible && editable) return true;
		else return false;
	}

	/**
	* ajoute une ligne  la table en demandant le refresh
	*
	* @author Nol Perez
	*/
	public void addValue(String[] _value)
	{
		addValue(_value, true);
		controlleur.refresh();
	}

	/**
	* retourne la ligne numero i sous la forme d'un tableau de String
	*
	* @author Nol Perez
	*/
	public String[] getValue(int i)
	{
		return (String[])(value.get(i));
	}

	/**
	* retourne le texte en rollback de la colonne _col
	*
	* @author Nol Perez
	*/
	public String getToolTipText(int _col)
	{
		if(_col>=0 && _col<nb_col) return tooltipColumn[_col];
		return null;
	}

	/**
	* retourne le nombre de colonne
	*
	* @author Nol Perez
	*/
	public int getColumnNumber()
	{
		return nb_col;
	}

	/**
	* retourne le nombre de ligne
	*
	* @author Nol Perez
	*/
	public int getSize()
	{
		return value.size();
	}
	
	/**
	* retourne la valeur contenue  la position _row, _col
	*
	* @param _row numero de ligne
	* @param _col numero de colonne
	* @author Nol Perez
	*/
	public Object getValueAt(int _row, int _col) 
	{
		//normalement ce test doit tre mis dans Atable, ici juste l'appel
		if(_row<value.size() && _col<nb_col) return ((String[])value.get(_row))[_col];
		else return null;
	}

	/**
	* affecte la valeur de la position _row, _col
	*
	* @param _aValue valeur  affecter
	* @param _row numero de ligne
	* @param _col numero de colonne
	* @author Nol Perez
	*/
	  public void setValueAt(Object _aValue, int _row, int _col) throws Exception
	  {
		if(priValueIsValid((String)_aValue, _row, _col, true))
	  	{
		  	if(addPossible && editable && _row==value.size())
	  		{
	//	  		System.out.println("ajout d'une ligne");
		  		String[] tmp = new String[nb_col];
		  		tmp[_col] = (String)_aValue;
		  		addValue(tmp,false);
			}
			else	
			{
				((String[])value.get(_row))[_col] = (String)_aValue;
			}
		}
	}

	/**
	* retourne le nom de la colonne$
	*
	* @param _column numero de la colonne demande
	*/
	public String getColumnName(int _column)
	{
		return nameColumn[_column];
	}

	/**
	* test si on peut ajouter des lignes
	*
	* @return true si on peut ajouter des lignes
	*/
	public boolean getAddPossible()
	{
		return addPossible;
	}
	
	/**
	* permet d'indiquer si on peut ajouter une valeur
	*/
	public void setAddPossible(boolean _possible)
	{
		this.addPossible = _possible;
		controlleur.refresh();  //utile afin de prendre en compte les modifications
	}

	//----------------------------------------------------------------------------
	/** 
	  * permet de charger les donnes de l'objet _o dans la table
	  *
	  * @param _o objet  charger dans la table
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public void load(Object _o)
	{
		value = new Vector();
		controlleur.refresh();  //utile au cas il n'y a pas de donne charger
		if(loader!=null) loader.load(this, _o);
	}

	//----------------------------------------------------------------------------
	/**
	  * permet de sauver les donnes de la table sous la forme d'un objet
	  *
	  * @return tableau d'objet dfini par la classe de chargement dechargement indiqu dans le properties
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public Object[] save()
	{
		if(loader!=null) return loader.save(this);
		return null;
	}

	//----------------------------------------------------------------------------
	/**
	  * permet de savoir si les valeurs de la table sont modifiables
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public boolean isEditable()
	{
		return editable;
	}
	
	//----------------------------------------------------------------------------
	/**
	  * Mutateur : specifie si la table est editable
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public void setEditable(boolean _edit)
	{
		editable = _edit;
	}
	
	/**
	* retourne true si la colonne _col est editable
	*
	* @param _row numero de ligne
	* @param _col numero de colonne
	* @author Nol Perez
	*/
	public boolean isCellEditable(int _row, int _col) 
	{
		//System.out.println("cell editable");
		//if(listSelectionModel.getMinSelectionIndex() == row && editable) return !readOnly[col];
		if(editable) return !readOnly[_col];
		else return false;
	}
	  
	//----------------------------------------------------------------------------
	/**
	  * rcuprant le titre associ  la table dans le fichier properties
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public String getTitle()
	{
		return this.title;
	}
	
	//----------------------------------------------------------------------------
	/**
	  * permet la suppression d'une ligne de la table
	  *
	  * @param _i numero de la ligne  supprimer
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public void delete(int _i)
	{
		value.remove(_i);
		controlleur.refresh();
	}
	
	//----------------------------------------------------------------------------
	/**
	  * retourne la valeur par dfaut de la colonne
	  *
	  * @param _col numro de colonne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public String getInitOfColumn(int _col)
	{
		return initValue[_col];
	}
	
	//----------------------------------------------------------------------------
	/**
	  * retourne le type de la colonne
	  *
	  * @param _col numro de colonne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public String getTypeOfColumn(int _col)
	{
		return typeColumn[_col];
	}
	
	//----------------------------------------------------------------------------
	/**
	  * retourne la liste des valeurs possibles pour la colonne
	  *
	  * @param _col numro de colonne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public String[] getListValueOfColumn(int _col)
	{
		return listValue[_col];
	}
	
	//----------------------------------------------------------------------------
	/**
	  * fonction permettant de transform une chaine en un tableau de chaine
	  * format reconnu item1;item2;item3;
	  *
	  * @param _liste chaine contenant les donnes du tableau
	  * @return tableau contenan les items
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	private String[] priReadStringArray(String _liste)
	{
		if(_liste!=null)
		{
			Vector temp = new Vector();
			int deb=0, fin;
			fin = _liste.indexOf(separator);
			while(fin!=-1)
			{
				temp.add(_liste.substring(deb,fin));
				deb = fin+1;
				fin = _liste.indexOf(separator,deb);
			}
			if(temp.size()>0)
			{
				String[] tt = new String[temp.size()];
				return (String[])(temp.toArray(tt));
			}
			else return null;
		}
		return null;
	}
	
	//----------------------------------------------------------------------------
	/**
	  * fonction permettant de tester la validit de l'entre courante  l position _row, _col
	  *
	  * @param _row numero de ligne o a t saisie la valeur
	  * @param _col numero de colonne o a t saisie la valeur
	  * @param _display indique s'il faut afficher les messages d'erreurs
	  * @return true si l'entree est valid
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	boolean valueIsValid(int _row, int _col, boolean _display) throws Exception
	{
		return priValueIsValid(((String[])value.get(_row))[_col],_row,_col,_display);
	}

	//----------------------------------------------------------------------------
	/**
	  * fonction permettant de tester la validit de la ligne _row
	  *
	  * @param _row numero de ligne o a t saisie la valeur
	  * @return true si la ligne est valid
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public boolean validLine(int _row) throws Exception
	{
		if(_row!=-1 && _row!=getSize())
		{
			int i =0;
			for(i=0;i<nb_col && valueIsValid(_row, i, true);i++){}
			if(i==nb_col) 
			{
				return true;
			}
			return false;
		}
		else
		{
			return true;
		}
	}

	//----------------------------------------------------------------------------
	/**
	  * fonction permettant de tester la validit d'une entre en fonction de sa colonne
	  *
	  * @param _value valeur  tester
	  * @param _row numero de ligne o a t saisie la valeur
	  * @param _col numero de colonne o a t saisie la valeur
	  * @param _display indique s'il faut afficher les messages d'erreurs
	  * @return true si l'entree est valid
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	boolean priValueIsValid(String _value, int _row, int _col, boolean _display) throws Exception
	{
//System.out.println("value test:"+_value+" ligne:"+_row+" colonne:"+_col+" affichage:"+_display+" requis:"+champsRequis[_col]);
		boolean ok = true;
		if( (_value==null || _value.length()==0 ) && champsRequis[_col]==true ) 
	  	{
	  		priCreateException(valueRequireMessage,_display);
		  	ok = false;
	  	}
	  	if(ok && _col == key)
	  	{
//System.out.println("key-colonne");
	  		//procede  la verification que la key-colonne joue son rle
		  	for(int i=0;i<_row;i++)
		  		if(_value.compareTo(((String[])value.get(i))[_col])==0) ok=false;
		  	for(int i=_row+1;i<value.size() && ok;i++)
		  		if(_value.compareTo(((String[])value.get(i))[_col])==0) ok=false;
			if(!ok)
			{
	  			priCreateException(doublonMessage,_display);
			}
	  	}
		if(ok && testRegex[_col]!=null)
	  	{
//System.out.println("colonne avec test:"+testRegex[_col]);
		  	// on test la valeur
		  	if(_value!=null)
		  	{
		  		RegularExpression test = new RegularExpression(testRegex[_col]);
				Match match = new Match();
		  		if( !(test.matches(_value,match) && match.getCapturedText(0).length()==_value.length()) )
				{
		  			priCreateException(valueNotCorrectMessage+testRegex[_col],_display);
		  			ok = false;
	  			}
	  		}
	  		else
	  		{
	  			priCreateException(valueNotCorrectMessage+testRegex[_col],_display);
	  			ok = false;
	  		}
		}
	  	return ok;
	}


	/**
	  * rcuperation de la valeur associ  la cl _key
	  *
	  * @param _key cl du properties dont on veut la valeur
	  * @return String valeur associ  _key dans le properties lu. Si il n'y a pas de valeur null 
	  */
	private String priGetPropertyValue(String _key)
	{
		try{
			return prop.getString(_key);
		}catch(Exception ex){return null;}
	}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//----------------------------------------------------------------------------
	/**
	  * indique s'il faut couter les dragdrop
	  *
	  * @return boolean - drop is possible
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public boolean isDropPossible()
	{
		return dropPossible;
	}
	
	//----------------------------------------------------------------------------
	/**
	  * indique s'il faut generer les event dragdrop
	  *
	  * @return boolean - drag is possible
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public boolean isDragPossible()
	{
		return dragPossible;
	}

	//----------------------------------------------------------------------------
	/**
	  * cre l'exception et la retourne s'il faut
	  *
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	private void priCreateException(String _message, boolean _display) throws ValidException
	{
		if(_display) 
			throw new ValidException(_message);
	}

}