/****************************************************
* auteur  : Nol Perez			 *
* date    : 20 aot 2002		 *
* fichier : CTable.java			 *
****************************************************/
/*
 * Rvisions :
 *
 * $Id$
 *
 * $Log$
 */

package perenono.pac.easytable;

import java.util.Vector;
import java.util.Locale;

/**
  * Partie controlleur du composant PAC, s'occupe du lien abstraction-presentation et entre composants
  * 
  * @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
  * @see this class is distributed under LGPL licence
  */ 
public class CTable
{

	/**
	* reference vers l'abstraction du composant
	*/
	private ATable abstrait;
	/**
	* reference vers un composant en coute des vnements de celui-ci
	*/
	private ITableListener publiclistener = null;
	/**
	* reference vers l'ensemble des presentation de ce composant
	*/
	private Vector privatelisteners = null;

	//----------------------------------------------------------------------------
	/** 
	  * Constructeur par dfaut de la classe CTable
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	private CTable(){}
	
	//----------------------------------------------------------------------------
	/** 
	  * Constructeur par dfaut de la classe CTable
	  *
	  * @param _fileTableProperties String - fichier definissant la table
	  * @param _fileAdminProperties String - fichier contenant les messages utilis par le composant
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public CTable(String _fileProperties, String _fileAdminProperties)
	{
		this(_fileProperties, _fileAdminProperties, null);
	}

	//----------------------------------------------------------------------------
	/** 
	  * Constructeur par dfaut de la classe CTable
	  *
	  * @param _fileTableProperties String - fichier definissant la table
	  * @param _fileAdminProperties String - fichier contenant les messages utilis par le composant
	  * @param _locale indique la localisation de l'application ( utilis pour la recherche des fichiers de proprits )
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public CTable(String _fileProperties, String _fileAdminProperties, Locale _locale)
	{
		privatelisteners = new Vector(2);
		abstrait = new ATable(this, _fileProperties, _fileAdminProperties, _locale);
	}

	//----------------------------------------------------------------------------
	/** 
	  * Fonction de cration d'une presentation avec un titre fourni
	  *
	  * @param _title nom du composant
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public Table createTable(String _title) 
	{ 
		if(_title!=null) return new Table(this, _title);
		else return createTable();
	}
	
	//----------------------------------------------------------------------------
	/** 
	  * Fonction de cration d'une presentation
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public Table createTable() 
	{ 
		return new Table(this, abstrait.getTitle());
	}

	public String toString()
	{
		StringBuffer strBufferTmp = new StringBuffer();
		strBufferTmp.append("Class CTable : ");

		strBufferTmp.append(" ]");
		return strBufferTmp.toString();
	}

	//----------------------------------------------------------------------------
	/** 
	  * declare en ecoute le composant listener
	  *
	  * @param _listener composant qui veut ecouter les venements du composant
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public void addPublicListener(ITableListener _listener)
	{
		//System.out.println("listener public ajout");
		publiclistener = _listener;
	}

	//----------------------------------------------------------------------------
	/** 
	  * declare en ecoute le composant listener
	  *
	  * @param _listener partie presentation qui se met en ecoute de l'abstraction
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	void addPrivateListener(IControlleurListener _listener)
	{
		//System.out.println("listener privee ajout");
		privatelisteners.add(_listener);
	}

	//----------------------------------------------------------------------------
	/** 
	  * envoie des donnes  charger
	  *
	  * @param _listener partie presentation qui se met en ecoute de l'abstraction
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public void load(Object _o)
	{
		abstrait.load(_o);	
	}

	//----------------------------------------------------------------------------
	/**
	  * envoie des donnes pour sauver celle de la table
	  *
	  * @param _listener partie presentation qui se met en ecoute de l'abstraction
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public Object[] save()
	{
		return abstrait.save();
	}

	//----------------------------------------------------------------------------
	/**
	  * permet l'ajout d'une ligne
	  *
	  * @param _params tableau contenant les valeurs pour une ligne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public void addLine(String[] _params)
	{
		abstrait.addValue(_params, true);
	}

	//----------------------------------------------------------------------------
	/**
	  * recupere une ligne de la table
	  *
	  * @param _pos ligne  recuperer
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public String[] getLine(int _pos)
	{
		try{
			return abstrait.getValue(_pos);
		}catch(Exception ex){return null;}
	}

	//----------------------------------------------------------------------------
	/**
	  * recupere le tooltiptext de la colonne _col
	  *
	  * @param _col numro de colonne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public String getToolTipText(int _col)
	{
		return abstrait.getToolTipText(_col);
	}
	
	//----------------------------------------------------------------------------
	/**
	  * rafraichissement
	  *
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public void refresh()
	{
		//publiclistener.listChanged(list,elemcour);
		int size = privatelisteners.size();
		for(int i=0;i<size;i++)
		{
			((IControlleurListener)(privatelisteners.elementAt(i))).refresh();
		}	
	}

	//----------------------------------------------------------------------------
	/**
	* retourne le nombre de colonne
	* @author Nol Perez
	*/
	//----------------------------------------------------------------------------
	public int getColumnNumber()
	{
		return abstrait.getColumnNumber();
	}

	//----------------------------------------------------------------------------
	/**
	* retourne le nombre de ligne
	* @author Nol Perez
	*/
	//----------------------------------------------------------------------------
	public int getSize()
	{
		return abstrait.getSize();
	}

	//----------------------------------------------------------------------------
	/**
	  * recupere la valeur de la ligne _row et de la colonne _col
	  *
	  * @param _row numro de ligne
	  * @param _col numro de colonne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public Object getValueAt(int _row, int _col) 
	{
		return abstrait.getValueAt(_row,_col);
	}

	//----------------------------------------------------------------------------
	/**
	  * depose l'objet _aValue  la ligne _row et de la colonne _col
	  * renvoie en exception les message  afficher
	  *
	  * @param _aValue  valeur a affecter
	  * @param _row numro de ligne
	  * @param _col numro de colonne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public void setValueAt(Object _aValue, int _row, int _col) throws Exception
	{
		abstrait.setValueAt(_aValue,_row,_col);
	}

	//----------------------------------------------------------------------------
	/**
	  * retourne le nom de la colonne _col
	  *
	  * @param _col numro de colonne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public String getColumnName(int column)
	{
		return abstrait.getColumnName(column);
	}

	//----------------------------------------------------------------------------
	/**
	  * retourne true si on peut ajouter des lignes
	  *
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public boolean isAddPossible()
	{
		return abstrait.getAddPossible();
	}
	
	//----------------------------------------------------------------------------
	/**
	  * retourne true si on peut modifier les valeurs charges dans la table
	  *
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public boolean isEditable()
	{
		return abstrait.isEditable();
	}
	
	//----------------------------------------------------------------------------
	/**
	  * retourne true si on peut modifier la valeur de la ligne _row et de colonne _col
	  *
	  * @param _row numro de ligne
	  * @param _col numro de colonne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public boolean isCellEditable(int _row, int _col) 
	{
		return abstrait.isCellEditable(_row,_col);
	}

	//----------------------------------------------------------------------------
	/**
	  * indique si la ligne peut tre supprimer
	  *
	  * @param _row ligne  recuperer
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public boolean isDeletable(int _row)
	{
		return abstrait.isDeletable(_row);
	}
	
	//----------------------------------------------------------------------------
	/**
	  * suppression d'une ligne
	  *
	  * @param _i ligne  supprimer
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public void delete(int _i)
	{
		abstrait.delete(_i);
	}
	
	//----------------------------------------------------------------------------
	/**
	  * indique s'il faut couter les dragdrop
	  *
	  * @return boolean - drop is possible
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public boolean isDropPossible()
	{
		return abstrait.isDropPossible();
	}
	
	//----------------------------------------------------------------------------
	/**
	  * indique s'il faut generer les event dragdrop
	  *
	  * @return boolean - drag is possible
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public boolean isDragPossible()
	{
		return abstrait.isDragPossible();
	}
	
	//----------------------------------------------------------------------------
	/**
	  * retourne le type de la colonne
	  *
	  * @param _col numro de colonne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	String getTypeOfColumn(int _col)
	{
		return abstrait.getTypeOfColumn(_col);
	}
	
	//----------------------------------------------------------------------------
	/**
	  * retourne la liste des valeurs possibles pour la colonne
	  *
	  * @param _col numro de colonne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	String[] getListValueOfColumn(int _col)
	{
		return abstrait.getListValueOfColumn(_col);
	}
	
	//----------------------------------------------------------------------------
	/**
	  * retourne la valeur par dfaut de la colonne
	  *
	  * @param _col numro de colonne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	String getInitOfColumn(int _col)
	{
		return abstrait.getInitOfColumn(_col);
	}
	
	//----------------------------------------------------------------------------
	/**
	  * retourne true si la valeur de la ligne _row et de colonne _col est correct au vue des contraintes de la colonne
	  *
	  * @param _row numro de ligne
	  * @param _col numro de colonne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	boolean valueIsValid(int _row, int _col, boolean _display) throws Exception
	{
		return abstrait.valueIsValid(_row,_col,_display);
	}

	//----------------------------------------------------------------------------
	/**
	  * retourne true si la valeur de la ligne _row
	  *
	  * @param _row numro de ligne
	  * @author Nol Perez
	  */
	//----------------------------------------------------------------------------
	public boolean validLine(int _row) throws Exception
	{
		return abstrait.validLine(_row);
	}
}