/****************************************************
* auteur  : Nol Perez			 *
* date    : 20 aot 2002		 *
* fichier : CTable.java			 *
****************************************************/
/*
 * Rvisions :
 *
 * $Id$
 *
 * $Log$
 */

package perenono.pac.easytable;

import java.io.*;
import java.awt.dnd.*;
import java.awt.datatransfer.*;
import java.util.List;
import java.util.Vector;

/**
  * Classe contenant les fonctions grant les actions de drag&drop
  * 
  * @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
  * @see this class is distributed under LGPL licence
  */ 
public class EcouteurDragAndDrop implements DropTargetListener, DragGestureListener, DragSourceListener 
{
	/**
	* partie graphique du composant
	*/
	public Table table;

	private EcouteurDragAndDrop(){}

	//----------------------------------------------------------------------------
	/** 
	  * Constructeur par dfaut de la classe EcouteurDragAndDrop
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public EcouteurDragAndDrop(Table _table)
	{
		table = _table;
	}

	/**
	* is invoked when you are dragging over the DropSite
	*/
	public void dragEnter (DropTargetDragEvent event) {  }
	public void dragExit (DropTargetEvent event) {  }
	public void dragOver (DropTargetDragEvent event) {  }
	public void dropActionChanged ( DropTargetDragEvent event ) { }

	//----------------------------------------------------------------------------
	/** 
	  * fonction appel lors du depos sur le composant ( parse l'element fourni et cre une nouvelle entre )
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public void drop (DropTargetDropEvent event)
	{
		try {
	        Transferable transferable = event.getTransferable();
	                   
		if (transferable.isDataFlavorSupported (DataFlavor.javaFileListFlavor))
		{
			//gestion du dept de fichier
			event.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
			List s = (List)(transferable.getTransferData(DataFlavor.javaFileListFlavor));
			if(s!=null && s.size()>0)
			{
				//System.out.println("drop file:/"+(s.get(0)).toString());
				//diapo.afficher("file:/"+(s.get(0)).toString());
			}
			event.getDropTargetContext().dropComplete(true);
	        }
	        else if (transferable.isDataFlavorSupported (DataFlavor.stringFlavor))
	        {
			//gestion du dept de chane de caractre
			event.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
			String s = (String)(transferable.getTransferData(DataFlavor.stringFlavor));
			if(s!=null)
			{
				table.addLine(priReadStringArray(s,','));
				//System.out.println("value:"+priReadStringArray(s,','));
				//diapo.afficher("value:"+(s.get(0)).toString());
			}
			event.getDropTargetContext().dropComplete(true);
	        }
	        else
	        {
			//on rejette l'event recu car il ne nous interesse pas
			event.rejectDrop();
	        }
		}
		catch (IOException exception)
		{
			System.err.println( "Exception" + exception.getMessage());
			event.rejectDrop();
		} 
		catch (UnsupportedFlavorException ufException )
		{
			System.err.println( "Exception" + ufException.getMessage());
			event.rejectDrop();
		}
	}

	/**
	* is invoked when you are dropping
	*/
	public void dragDropEnd(DragSourceDropEvent e) {}
	public void dragEnter(DragSourceDragEvent e) {}
	public void dragExit(DragSourceEvent e) {}
	public void dragOver(DragSourceDragEvent e) {}
	public void dropActionChanged(DragSourceDragEvent e) {}

	//----------------------------------------------------------------------------
	/** 
	  * fonction appel lors du gliss depuis le composant ( formatte la ligne selectionne sous la forme d'un chaine )
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public void dragGestureRecognized(DragGestureEvent e)
	{
		String[] list = table.getLine();
		StringBuffer temp = new StringBuffer();
		if(list!=null)
		{
			for(int i=0;i<list.length;i++)
			{
				if(list[i]!=null) temp.append(list[i]).append(',');
				else temp.append(',');
			}
			if(temp.length()>0)
				temp.setLength(temp.length()-1);
		
		 	e.startDrag(DragSource.DefaultCopyDrop, // cursor
		    		new StringSelection(temp.toString()), // transferable
		    		this); // drag source listener
		}
	}

	//----------------------------------------------------------------------------
	/**
	  * fonction permettant de transform une chaine en un tableau de chaine
	  * format reconnu item1;item2;item3
	  *
	  * @param _liste chaine contenant les donnes du tableau
	  * @return tableau contenan les items
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	private String[] priReadStringArray(String _liste, char _sep)
	{
		if(_liste!=null)
		{
			Vector temp = new Vector();
			int deb=0, fin;
			fin = _liste.indexOf(_sep);
			while(fin!=-1)
			{
				temp.add(_liste.substring(deb,fin));
				deb = fin+1;
				fin = _liste.indexOf(_sep,deb);
			}
			if(temp.size()>0)
			{
				if(deb<_liste.length()) temp.add(_liste.substring(deb));
				
				String[] tt = new String[temp.size()];
				return (String[])(temp.toArray(tt));
			}
			else return null;
		}
		return null;
	}

}