/****************************************************
* auteur  : Nol Perez			 	*
* date    : 20 aot 2002			*
* fichier : Table.java			 	*
****************************************************/
/*
 * Rvisions :
 *
 * $Id$
 *
 * $Log$
 */

package perenono.pac.easytable;

//--> java
import java.awt.BorderLayout;
import javax.swing.BorderFactory;

import java.awt.event.MouseEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.dnd.*;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.DefaultCellEditor;
import javax.swing.ListSelectionModel;
import javax.swing.DefaultListSelectionModel;

import javax.swing.JScrollPane;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JPanel;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.event.TableModelEvent;

/**
  * presentation de la table
  * 
  * @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
  * @see this class is distributed under LGPL licence
  */ 
public class Table extends JPanel implements IControlleurListener
{
	/**
	* reference vers le controlleur
	*/
	public CTable controlleur;
	/**
	* table affich
	*/
	private JTable table;
	/**
	* popup de supression
	*/
	private JPopupMenu popup;
	/**
	* model de selection des lignes
	*/
	private AListSelectionModel listSelectionModel;

	//----------------------------------------------------------------------------
	/** 
	  * Constructeur par dfaut de la classe ExemplePresentation
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	private Table(){}

	//----------------------------------------------------------------------------
	/** 
	  * Constructeur par dfaut de la classe Table
	  *
	  * @param _controlleur controlleur  utiliser
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public Table(CTable _controlleur, String _title)
	{
		super();
	      	
	      	/*
		code graphique
		*/
		this.controlleur = _controlleur;
		this.controlleur.addPrivateListener(this);

		setLayout(new BorderLayout());
		setBorder(BorderFactory.createTitledBorder(_title));
		
		ATableModel _dataModel = new ATableModel();
		setToolTipText("");
		table = new AdaptTable();
		table.setModel(_dataModel);
		table.setSelectionModel(getSelectionModel());
		table.addMouseListener(new TablePopup());
		
		add(new JScrollPane(table),BorderLayout.CENTER);
	
		for(int i=0;i<_dataModel.getColumnCount();i++)
		{
			TableColumn sportColumn = table.getColumnModel().getColumn(i);
			
			//si c'est une list ou une listeditable on asocie l'action  la colonne
			JComboBox combo = getActionColumn(i);
			if(combo!=null)
				sportColumn.setCellEditor(new DefaultCellEditor(combo));
		}
      	
	      	popup = new JPopupMenu();
	      	JMenuItem supp = new JMenuItem("Supprimer");
	      	supp.addActionListener(new ActionEcouteur());
	      	popup.add(supp);

		//ecoute
		EcouteurDragAndDrop dnd = new EcouteurDragAndDrop(this);
		if(controlleur.isDropPossible())
		{
			new DropTarget(this, DnDConstants.ACTION_COPY_OR_MOVE,dnd);
			new DropTarget(table, DnDConstants.ACTION_COPY_OR_MOVE,dnd);
		}
	
		if(controlleur.isDragPossible())
		{
			DragSource dragSource = DragSource.getDefaultDragSource();
			dragSource.createDefaultDragGestureRecognizer(table, DnDConstants.ACTION_COPY_OR_MOVE, dnd);
		}
	}

	//----------------------------------------------------------------------------
	/**
	* force l'affichage des modifications de la table
	*
	* @author Nol Perez
	*/
	//----------------------------------------------------------------------------
	public void refresh()
	{
		try{
//			table.requestFocus();
//			table.revalidate();
//			table.doLayout();
//			table.getParent().getParent().repaint();
			table.updateUI();
			table.repaint();
		}catch(Exception ex){/*juste pour resoudre petit problme au lancement*/}
	}

	//----------------------------------------------------------------------------
	/**
	* ajout d'une ligne
	*
	* @param _params table contenant les differentes valeurs pour une ligne
	* @author Nol Perez
	*/
	//----------------------------------------------------------------------------
	public void addLine(String[] _params)
	{
		controlleur.addLine(_params);
	}
	
	//----------------------------------------------------------------------------
	/**
	* recuperation de la ligne selectionne
	*
	* @author Nol Perez
	*/
	//----------------------------------------------------------------------------
	public String[] getLine()
	{
		int pos = table.getSelectedRow();
		if(pos>=0)
		{
			return controlleur.getLine(pos);
		}
		return null;
	}
	
	//----------------------------------------------------------------------------
	/**
	  * rcupre le ListSelectionModel pour utilisation par la JTable
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public AListSelectionModel getSelectionModel()
	{
		if(listSelectionModel==null)
		{
			listSelectionModel = new AListSelectionModel();
		}
		return listSelectionModel;
	}

	//----------------------------------------------------------------------------
	/**
	  * rcupre l'action ( component affich ) pour la colonne _col
	  *
	  * @param _col colonne concerne 0..size-1
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public JComboBox getActionColumn(int _col)
	{
		String type = controlleur.getTypeOfColumn(_col);
		if( type.equals(ATable.LIST) || type.equals(ATable.LISTEDITABLE) )
		{
			String[] listValue = controlleur.getListValueOfColumn(_col);
			if(listValue!=null)
			{
				JComboBox temp = new JComboBox(listValue);
//				temp.setToolTipText(controlleur.getToolTipText(_col));
				temp.setSelectedItem(controlleur.getInitOfColumn(_col));
				if(type.equals(ATable.LISTEDITABLE)) 
				{
					temp.setEditable(true);
				}
				return temp;
			}
		}
		return null;
	}
	
	//----------------------------------------------------------------------------
	/**
	  * classe gerant le click droit sur une ligne en vue d'une suppression
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public class TablePopup extends java.awt.event.MouseAdapter
	{

		//----------------------------------------------------------------------------
		/**
		  * fonction gerant le click sur la table
		  *
		  * @param e evenement de la souris
		  * @author Nol Perez
		  */ 
		//----------------------------------------------------------------------------
		public void mouseReleased(MouseEvent e)
		{
			if (e.isShiftDown()||e.isControlDown()||e.isAltDown())
			{
		        	return;
			}
			if (e.isMetaDown())
			{
				java.awt.Point point = e.getPoint(); 
		        	int row = table.rowAtPoint(point);
				table.setRowSelectionInterval(row,row);
				if(controlleur.isDeletable(row)) popup.show(table, point.x, point.y);
			}
		}
	
	}

	//----------------------------------------------------------------------------
	/**
	  * classe traitant uniquement l'appuie sur l'item de suppression
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	private class ActionEcouteur implements ActionListener
	{
		//----------------------------------------------------------------------------
		/**
		  * fonction gerant les clicks sur le bouton supprimer
		  *
		  * @param e evenement du bouton
		  * @author Nol Perez
		  */ 
		//----------------------------------------------------------------------------
		public void actionPerformed(ActionEvent e)
		{
			controlleur.delete(table.getSelectedRow());
		}
	}
	
	
	//----------------------------------------------------------------------------
	/**
	  * classe surchargeant la JTable afin de prendre en compte les tooltiptext
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public class AdaptTable extends JTable
	{
		
		//----------------------------------------------------------------------------
		/**
		  * fonction gerant l'affichage des bulle d'aides
		  *
		  * @param e evenement du bouton
		  * @author Nol Perez
		  */ 
		//----------------------------------------------------------------------------
		public String getToolTipText(MouseEvent e)
		{
			int column = table.columnAtPoint(e.getPoint());
			return controlleur.getToolTipText(column);
		}
	}

	//----------------------------------------------------------------------------
	/**
	  * classe gerant le changemet de ligne ( afin de tester les requis )
	  * elle est plac en interne afin de ne pas doubler les donnes
	  * toute les fonctions sont celle standard ( voir doc Sun )
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public class AListSelectionModel extends javax.swing.DefaultListSelectionModel
	{

		//----------------------------------------------------------------------------
		/**
		  * constructeur
		  *
		  * @author Nol Perez
		  */ 
		//----------------------------------------------------------------------------
		public AListSelectionModel()
		{
			super();
			//doit tre present sous peine d'entrainer des erreurs dans les tests
			setSelectionMode(SINGLE_SELECTION);
		}
		
		//----------------------------------------------------------------------------
		/**
		  * fonction surcharger afin de tester la ligne s'il y a changement de ligne
		  * on test chaque champs, s'il y a une erreur on empche le passage sur une nouvelle ligne
		  *
		  * @author Nol Perez
		*/
		//----------------------------------------------------------------------------
		public void setSelectionInterval(int _first, int _last) 
		{
			try
			{
				int old = getMinSelectionIndex();
				int nb_col = controlleur.getColumnNumber();
		//System.out.println("row selected changed --old:"+old+" new:"+_last);
				if(old!=_first)
				{
					if(controlleur.validLine(old))
					{
						super.setSelectionInterval(_first,_last);
					}
					else
					{
						JOptionPane.showOptionDialog(null,"ligne incorrect","erreur",JOptionPane.DEFAULT_OPTION,JOptionPane.ERROR_MESSAGE,null,null,null);
					}
				}
				else
				{
System.out.println("select interval2");
					super.setSelectionInterval(_first,_last);
	//System.out.println("changement ok");
				}
			}catch(ValidException ex)
			{
				JOptionPane.showOptionDialog(null,ex.getMessage(),"erreur",JOptionPane.DEFAULT_OPTION,JOptionPane.ERROR_MESSAGE,null,null,null);
//				ex.printStackTrace();
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
	
	}

//-> classes utilises en interne par le composant pour gerer les actions et faire les verification qui s'impose	
	
	//----------------------------------------------------------------------------
	/**
	  * classe gerant l'affichage des donnes dans la JTable
	  * elle est plac en interne afin de ne pas doubler les donnes
	  * toute les fonctions sont celle standard ( voir doc Sun sur AbstractTableModel )
	  *
	  * @author Nol Perez
	  */ 
	//----------------------------------------------------------------------------
	public class ATableModel extends AbstractTableModel
	{

		//----------------------------------------------------------------------------
		/**
		  * retourne le nombre de colonne
		  *
		  * @author Nol Perez
		  */ 
		//----------------------------------------------------------------------------
	          public int getColumnCount()
	          {
	          	return controlleur.getColumnNumber();
	          }
	          
		//----------------------------------------------------------------------------
		/**
		  * retourne le nom de la colonne _column
		  *
		  * @param _column numero de colonne
		  * @author Nol Perez
		  */ 
		//----------------------------------------------------------------------------
	          public String getColumnName(int _column)
	          {
	          	return controlleur.getColumnName(_column);
	          }
	          
		//----------------------------------------------------------------------------
		/**
		  * retourne le nombre de ligne
		  *
		  * @author Nol Perez
		  */ 
		//----------------------------------------------------------------------------
	          public int getRowCount()
	          {
		          // le test permet d'empecher l'ajout depuis l'IHM
		          int size = controlleur.getSize();
		          if(controlleur.isAddPossible() && controlleur.isEditable()) return size+1;
		          else return size;
	          }
	
		//----------------------------------------------------------------------------
		/**
		  * retourne la valeur  la position _row, _col
		  *
		  * @param _col numero de la colonne
		  * @param _row numero de la ligne
		  * @author Nol Perez
		  */ 
		//----------------------------------------------------------------------------
	          public Object getValueAt(int _row, int _col) 
	          {
			return controlleur.getValueAt(_row,_col);
	          }
	          
		//----------------------------------------------------------------------------
		/**
		  * retourne true si la valeur  la position _row, _col peut tre modifie
		  *
		  * @param _col numero de la colonne
		  * @param _row numero de la ligne
		  * @author Nol Perez
		  */ 
		//----------------------------------------------------------------------------
		  public boolean isCellEditable(int _row, int _col) 
		  {
			return controlleur.isCellEditable(_row,_col);
		  }
		  
		//----------------------------------------------------------------------------
		/**
		  * affecte l'objet _aVlue  la position _row, _col
		  *
		  * @param _aValue valeur  entrer
		  * @param _col numero de la colonne
		  * @param _row numero de la ligne
		  * @author Nol Perez
		  */ 
		//----------------------------------------------------------------------------
		public void setValueAt(Object _aValue, int _row, int _col)
		{
			try{
				controlleur.setValueAt(_aValue,_row,_col);
			}catch(ValidException ex)
			{
				JOptionPane.showOptionDialog(null,ex.getMessage(),"erreur",JOptionPane.DEFAULT_OPTION,JOptionPane.ERROR_MESSAGE,null,null,null);
//				ex.printStackTrace();
			}
			catch(Exception ex){}
		}
	
	}

}