package perenono.util;

import java.applet.Applet;
import java.awt.*;
import java.util.Vector;
import java.util.StringTokenizer;

/**
* class GraphApplet use AWTGraph to display a chart
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
* @version 1.0
* @see this class is distributed under LGPL licence
*/
public class GraphApplet extends Applet
{

private static final String PARAM_BACKGROUND = "BACKGROUND";
private static final String PARAM_COLORS = "COLORS";
private static final String PARAM_VALUES = "VALUES";
private static final String PARAM_TITLE = "TITLE";
private static final String PARAM_XTITLE = "XTITLE";
private static final String PARAM_YTITLE = "YTITLE";
private static final String PARAM_XUNIT = "XUNIT";
private static final String PARAM_YUNIT = "YUNIT";
private static final String PARAM_GRID = "GRID";
private static final String PARAM_MODE = "MODE";
private static final String PARAM_FILL = "FILL";

private static final String DIAG = "diagramme";
private static final String STICK = "baton";
private static final String CURVE = "courbe";
private static final String DOT = "point";

private AWTGraph graph;
/**
*procedure appele au debut du programme
*/
public void init()
{
	graph = new AWTGraph();
	setBackground(parseColor(getParameter(PARAM_BACKGROUND)));
	setColors(getParameter(PARAM_COLORS));
	setValues(getParameter(PARAM_VALUES));
	setMode(getParameter(PARAM_MODE));
	graph.setXAxisTitle(getParameter(PARAM_XTITLE));
	graph.setYAxisTitle(getParameter(PARAM_YTITLE));
	graph.setTitle(getParameter(PARAM_TITLE));

	setGrid(getParameter(PARAM_GRID));
	setFill(getParameter(PARAM_FILL));
	setXUnit(getParameter(PARAM_XUNIT));
	setYUnit(getParameter(PARAM_YUNIT));
	
	setLayout(new BorderLayout());
	add(graph,BorderLayout.CENTER);
}

/**
* permet de selectionner les couleurs d'affichage
* @param _colors : string contenant les couleurs au format hexadecimal spars par une virgule
*/
private void setColors(String _colors)
{
	if(_colors!=null)
	{
		StringTokenizer st = new StringTokenizer(_colors,",");
		Vector res = new Vector();
		while (st.hasMoreTokens())
		{
			String temp = st.nextToken();
			Color col = parseColor(temp);
			if(col!=null)
			{
				res.addElement(col);
			}
		}

		Color[] colors = new Color[res.size()];
		for(int i=0;i<res.size();i++)
			colors[i] = (Color)(res.elementAt(i));
		graph.setColors(colors);
	}
}

/**
* permet d'obtenir la couleur correspondant  un code hexadecimal
* @param _color : string contenant la couleur au format hexadecimal
*/
private Color parseColor(String _color)
{
	if(_color.length()==6)
	{
		int red = Integer.decode("#"+_color.substring(0,2)).intValue();
		int green = Integer.decode("#"+_color.substring(2,4)).intValue();
		int blue = Integer.decode("#"+_color.substring(4)).intValue();
		return new Color(red,green,blue);
	}
	return null;
}

/**
* permet de fournir les valeurs  afficher
* @param _values : string contenant les valeurs (double) spars par une virgule
*/
private void setValues(String _values)
{
	if(_values!=null)
	{
		StringTokenizer st = new StringTokenizer(_values,",");
		Vector res = new Vector();
		while (st.hasMoreTokens())
		{
			res.addElement(new Double(st.nextToken()));
		}

		double[] doubles = new double[res.size()];
		for(int i=0;i<res.size();i++)
			doubles[i] = ((Double)(res.elementAt(i))).doubleValue();
		graph.setValues(doubles);
	}
}

/**
* permet d'indiquer le mode d'affichage
* @param _mode : DIAG/STICK/CURVE/DOT
*/
public void setMode(String _mode)
{
	if(_mode!=null)
	{
		String mode = _mode.toLowerCase();
		if(DIAG.compareTo(_mode)==0) graph.setMode(AWTGraph.DIAG);
		else if(STICK.compareTo(_mode)==0) graph.setMode(AWTGraph.STICK);
		else if(CURVE.compareTo(_mode)==0) graph.setMode(AWTGraph.CURVE);
		else if(DOT.compareTo(_mode)==0) graph.setMode(AWTGraph.DOT);
	}
}

/**
* permet d'afficher ou non la grille
*/
public void setGrid(String _grid)
{
	if(_grid!=null) graph.setGrid(Boolean.valueOf(_grid).booleanValue());
}

/**
* permet de remplir ou non un diagramme
*/
public void setFill(String _fill)
{
	if(_fill!=null) graph.setFill(Boolean.valueOf(_fill).booleanValue());
}

/**
* permet d'indiquer l'uniter de l'abscisse
* @param _xunit : string representant un entier
*/
private void setXUnit(String _xunit)
{
	Double temp = new Double(_xunit);
	if(_xunit!=null) graph.setXAxisUnitIncrement(temp.doubleValue());
}

/**
* permet d'indiquer l'uniter de l'ordonner
* @param _yunit : string representant un entier
*/
private void setYUnit(String _yunit)
{
	Double temp = new Double(_yunit);
	if(_yunit!=null) graph.setYAxisUnitIncrement(temp.doubleValue());
}

/**
* renvoie une chaine dcrivant l'applet
*/
public String getAppletInfo()
{
	StringBuffer temp = new StringBuffer();
	temp.append("GraphApplet est une applet ralise par Nol Perez qui utilise la bibliothque JGraph\n");
	temp.append("Version 1.0\n");
	temp.append("la dernire version est accessible  l'adresse : http://freeware.pere-nono.com\n");
	temp.append("copyright 1999-2002 Pere-nono\n");
	
	return temp.toString();
}

}