package perenono.util;

import java.awt.*;
import java.awt.image.*;
import java.awt.geom.*;
import javax.swing.*;

/**
* class JGraph is use to display a diagram or a sharp in a swing window
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
* @version 1.0
* @see this class is distributed under LGPL licence
*/
public class JGraph extends JLayeredPane
{
/**
* mode for display the value with rectangle
*/
public static int DIAG = 0;
/**
* mode for display the value with line
*/
public static int STICK = 1;
/**
* mode for display the value with a curve
*/
public static int CURVE = 2;
/**
* mode for display the value with dots
*/
public static int DOT = 3;

private int mode = DIAG;
private boolean grid = false;
private boolean fill = false;
private String title = "";
private String xAxisTitle = "", yAxisTitle = "";
private double xAxisUnitIncrement =2, yAxisUnitIncrement =2;
private double xAxisMax=10, yAxisMax=10;
private double[] value ={1.0, 2.0, 6.0, 4.0};
private String[] valueTitle = {""};
private boolean auto = false;;

private static Color[] colors={Color.blue,Color.magenta,Color.green,Color.red,Color.gray};

private FontMetrics fontmetrics;

private int dotx, doty;

private int chartWidth;
private int chartHeight;
private int originex;
private int originey;
private double incrementx =1, incrementy =1, max=6;

/**
* constructor
*/
public JGraph()
{
setPreferredSize(new Dimension(200,200));
}

////////////////////////////////////////////////////////////////////////
/**
* set the display mode
* that can be DIAG ou STICK ou DOT ou CURVE
*/
public void setMode(int mode)
{
this.mode = mode;
repaint();
}
/**
* return the current mode
*/
public int getMode()
{
return mode;
}

/////////////////////////////////////////////////////////////////////////
/**
* set the title of the diagram
*/
public void setTitle(String title)
{
this.title = title;
repaint();
}
/**
* return the current title of this graph
*/
public String getTitle()
{
return title;
}

/////////////////////////////////////////////////////////////////////////
/**
* if grille is true, a grid is display
*/
public void setGrid(boolean grid)
{
this.grid = grid;
repaint();	
}
/**
* return true if a grid is display
*/
public boolean isGrid()
{
return grid;
}

/////////////////////////////////////////////////////////////////////////
/**
* if it is in normal mode and full is true, it fill the rectangle
*/
public void setFill(boolean fill)
{
this.fill = fill;
repaint();
}
/**
* return true if the diagram is fill
*/
public boolean isFill()
{
return fill;
}

/////////////////////////////////////////////////////////////////////////
/**
* set the titles of the Y axis
* @param xAxisTitle title on x-axis
*/
public void setXAxisTitle(String xAxisTitle)
{
this.xAxisTitle = xAxisTitle;
repaint();
}
/**
* return the title for the X axis
*/
public String getXAxisTitle()
{
return xAxisTitle;
}

/////////////////////////////////////////////////////////////////////////
/**
* set the titles of the Y axis
* @param yAxisTitle title on y-axis
*/
public void setYAxisTitle(String yAxisTitle)
{
this.yAxisTitle = yAxisTitle;
repaint();
}
/**
* return the title for the Y axis
*/
public String getYAxisTitle()
{
return yAxisTitle;
}

/////////////////////////////////////////////////////////////////////////
/**
* allow you to use the automatic mode that choose alone the best increment unit on y-axis
* @param val : if true the component use the automatic mode
*/
public void setAutoMode(boolean val)
{
auto = val;
if(value!=null) yAxisUnitIncrement = getUnitIncrement(max);
repaint();
}
/**
* return true if the program choose alone the best increment unit 
*/
public boolean isAutoMode()
{
return auto;
}

/////////////////////////////////////////////////////////////////////////
/**
* set the diplay value ( if the grqph is in auto_mode, it's calculate the yUnitIncrement)
* @param value array of double value
*/
public void setValue(double[] value) 
{
max = arrayMax(value);
this.value = value;
if(auto) yAxisUnitIncrement = getUnitIncrement(max); 
repaint();
}
public double[] getValue()
{
return value;
}

/////////////////////////////////////////////////////////////////////////
/**
* set the diplay value and the associated name
* @param value array of double value
* @param valueTitle array with the name of the different values ( not display for the moment )
*/
public void setValue2(double[] value, String[] valueTitle)
{
if(value!=null && valueTitle!=null && value.length == valueTitle.length)
	{
	this.valueTitle = valueTitle;
	}
else valueTitle = null;
setValue(value);
repaint();
}

/////////////////////////////////////////////////////////////////////////
/**
* set the value for the visible increment on xAxis axe
* @param xAxisUnitIncrement xAxis increment
*/
public void setXAxisUnitIncrement(double xAxisUnitIncrement)
{
this.xAxisUnitIncrement = xAxisUnitIncrement;
repaint();
}
/**
* return the increment unit for the x axis
*/
public double getXAxisUnitIncrement()
{
return xAxisUnitIncrement;
}

/////////////////////////////////////////////////////////////////////////
/**
* set the value for the visible increment on yAxis axe and desactivate the auto mode
* @param yAxisUnitIncrement yAxis increment
*/
public void setYAxisUnitIncrement(double yAxisUnitIncrement)
{
auto = false;
this.yAxisUnitIncrement = yAxisUnitIncrement;
repaint();
}
/**
* return the increment unit for the axis
*/
public double getYAxisUnitIncrement()
{
return yAxisUnitIncrement;
}

/////////////////////////////////////////////////////////////////////////
////////   methodes utilis pour l'affichage    /////////////////////////
/////////////////////////////////////////////////////////////////////////
public void update(Graphics g)
{
paint(g);
}

/**
* display the graph
*/
public void paint(Graphics g)
{
chartWidth = getWidth()-70;
chartHeight = getHeight()-100;

originex = 60;
originey = 40+chartHeight;

incrementx =1;
incrementy =1;

if(value!=null)
	{
	incrementy = (chartHeight*yAxisUnitIncrement)/arrayMax(value);
	incrementx = chartWidth/value.length;
	}

// display main title
g.setColor(Color.black);
fontmetrics = g.getFontMetrics();
if(title!=null) g.drawString(title,(getWidth()-fontmetrics.stringWidth(title))/2,16);

//display values
paintValues(g);

//display the axes
paintAxes(g);
}

/////////////////////////private zone////////////////////////////////

/**
* display the values in function of the mode
*/
private void paintValues(Graphics g)
{
g.setColor(Color.blue);
if(value!=null)
{
   for(int i=0, pos=originex;i<value.length;i++)
	{
	if(mode==DIAG)
		{
		g.setColor(colors[i%colors.length]);
		int temp = (int)((value[i]*(double)chartHeight)/max);
		if(fill) g.fillRect(pos,originey-temp,(int)incrementx,temp);
		else g.drawRect(pos,originey-temp,(int)incrementx,temp);
		}
	else if(mode==STICK || mode==DOT || mode==CURVE)
		{
		int positionx = pos+(int)(incrementx/2);
		int positiony = originey-(int)((value[i]*(double)chartHeight)/max);
		if(mode==STICK)
			{
			g.drawLine(positionx,positiony,positionx,originey);
			}
		else if(mode==DOT)
			{
			g.drawLine(positionx-5,positiony-5,positionx+5,positiony+5);
			g.drawLine(positionx-5,positiony+5,positionx+5,positiony-5);
			}
		else if(mode==CURVE)
			{
			if(i!=0) g.drawLine(dotx,doty,positionx,positiony);
			dotx = positionx;
			doty = positiony;
			}
		}
	pos +=incrementx;
	}
}
}

/**
* display the axes and the increment value
*/
private void paintAxes(Graphics g)
{
g.setColor(Color.black);
g.drawLine(originex,originey,originex+chartWidth,originey);
g.drawLine(originex+chartWidth-6,originey-6,originex+chartWidth,originey);
g.drawLine(originex+chartWidth-6,originey+6,originex+chartWidth,originey);

for(int i=originex,j=0;i<chartWidth+originex;i+=incrementx*xAxisUnitIncrement,j+=xAxisUnitIncrement)
	{
	g.drawLine(i,originey,i,originey+5);
	g.drawString(""+j,i,originey+14);
	}
for(int axeVal = 0;axeVal<=max;axeVal+=yAxisUnitIncrement)
	{
	int temp = originey-(int)((axeVal*(double)chartHeight)/max);
	String label = ""+axeVal;
	g.drawLine(originex,temp,originex-5,temp);
	g.drawString(label,originex-(fontmetrics.stringWidth(""+label)+5),temp);
	if(grid && axeVal!=0) 
		{
		g.setColor(Color.gray);
		g.drawLine(originex,temp,originex+chartWidth,temp);
		g.setColor(Color.black);
		}
	}

g.drawLine(originex,originey-chartHeight,originex,originey);
g.drawLine(originex-6,originey-chartHeight+6,originex,originey-chartHeight);
g.drawLine(originex+6,originey-chartHeight+6,originex,originey-chartHeight);

//display axes and theirs titles
g.setColor(Color.blue);
if(xAxisTitle!=null) g.drawString(xAxisTitle,60+(chartWidth-fontmetrics.stringWidth(xAxisTitle))/2,getHeight()-10);
if(yAxisTitle!=null) drawVerticalString(yAxisTitle,15,getHeight()-(60+(chartHeight-fontmetrics.stringWidth(yAxisTitle))/2),(Graphics2D)g);

}

/**
* draw a string in diagonal at the position (posX,posY) with an angle of theta rad
*/
private void drawDiagonalString(String text, int posX, int posY, double theta, Graphics2D g)
{
if(text!=null)
	{
	g.rotate(theta,posX,posY);
	g.drawString(text,posX,posY);
	g.rotate(-theta,posX,posY);
	}
}

/**
* draw a string in vertical at the position (posX,posY)
*/
private void drawVerticalString(String text, int posX, int posY, Graphics2D g)
{
if(text!=null) drawDiagonalString(text,posX,posY,-Math.PI/2,g);
}

/**
* search the max value of an array
* @param value array of double value
* @return the max value of the array
*/
private double arrayMax(double[] value)
{
double max = 0;
if(value!=null && value.length>0)
	{
	max = value[0];
	for(int i =1;i<value.length;i++)
		{
		if(max<value[i]) max = value[i];
		}
	}
return max;
}

/**
* choose the best increment in function of a max value
* @param val max value to display
* @return the best increment size
*/
private double getUnitIncrement(double val)
{
double max =100.0, min =50.0;
double increment = 10.0;
while(val<min || val>=max)
	{
	if(val<min)
		{
		increment/=2;
		max/=2;
		min/=2;
		}
	else	{
		increment*=2;
		max*=2;
		min*=2;
		}
	}
return increment;	
}

}