/*
 * Decompiled with CFR 0.152.
 */
package perenono.util.zip.compress;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class GZipCompress {
    public static int BUFFER_SIZE = 10000;

    public static void compress(String string, String string2) throws NullPointerException, IOException, SecurityException {
        GZipCompress.compress(new File(string), new File(string2));
    }

    public static void compress(File file, File file2) throws NullPointerException, IOException, SecurityException {
        if (file.exists() || file.createNewFile()) {
            GZipCompress.compress(new FileOutputStream(file), file2);
        }
    }

    public static void compress(OutputStream outputStream, File file) throws NullPointerException, IOException, SecurityException {
        DataInputStream dataInputStream = null;
        FilterOutputStream filterOutputStream = null;
        GZIPOutputStream gZIPOutputStream = null;
        try {
            byte[] byArray = new byte[BUFFER_SIZE];
            int n = 0;
            dataInputStream = new DataInputStream(new FileInputStream(file));
            gZIPOutputStream = new GZIPOutputStream(outputStream);
            filterOutputStream = new DataOutputStream(gZIPOutputStream);
            while (dataInputStream.available() > 0) {
                n = dataInputStream.read(byArray, 0, BUFFER_SIZE);
                ((DataOutputStream)filterOutputStream).write(byArray, 0, n);
            }
        }
        catch (EOFException eOFException) {
            System.out.println("End of stream encountered");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (filterOutputStream != null) {
            filterOutputStream.close();
            gZIPOutputStream.finish();
        }
    }
}

