/*
 * Decompiled with CFR 0.152.
 */
package perenono.util.zip.compress;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipCompress {
    public static int BUFFER_SIZE = 10000;

    public static void compress(String string, String[] stringArray) throws NullPointerException, IOException, SecurityException {
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < fileArray.length) {
            fileArray[n] = new File(stringArray[n]);
            ++n;
        }
        ZipCompress.compress(new File(string), fileArray);
    }

    public static void compress(File file, File[] fileArray) throws NullPointerException, IOException, SecurityException {
        if (file.exists() || file.createNewFile()) {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            ZipCompress.compress(zipOutputStream, file, fileArray, "");
            zipOutputStream.close();
        }
    }

    private static void compress(ZipOutputStream zipOutputStream, File file, File[] fileArray, String string) throws NullPointerException, IOException, SecurityException {
        int n = 0;
        while (n < fileArray.length) {
            Object object;
            if (fileArray[n].isFile()) {
                if (file.getCanonicalPath().compareTo(fileArray[n].getCanonicalPath()) != 0) {
                    object = new ZipEntry(string + fileArray[n].getName());
                    zipOutputStream.putNextEntry((ZipEntry)object);
                    ZipCompress.copy(zipOutputStream, fileArray[n]);
                    zipOutputStream.closeEntry();
                }
            } else {
                object = null;
                object = fileArray[n].getName().compareTo(".") == 0 || fileArray[n].getName().compareTo("..") == 0 ? "" : (string.compareTo(".") == 0 || string.compareTo("..") == 0 || string.compareTo("./") == 0 || string.compareTo("../") == 0 ? fileArray[n].getName() + "/" : string + fileArray[n].getName() + "/");
                ZipCompress.compress(zipOutputStream, file, fileArray[n].listFiles(), (String)object);
            }
            ++n;
        }
    }

    private static void copy(OutputStream outputStream, File file) throws NullPointerException, IOException, SecurityException {
        FilterInputStream filterInputStream = null;
        DataOutputStream dataOutputStream = null;
        try {
            byte[] byArray = new byte[BUFFER_SIZE];
            int n = 0;
            filterInputStream = new DataInputStream(new FileInputStream(file));
            dataOutputStream = new DataOutputStream(outputStream);
            while (filterInputStream.available() > 0) {
                n = ((DataInputStream)filterInputStream).read(byArray, 0, BUFFER_SIZE);
                dataOutputStream.write(byArray, 0, n);
            }
        }
        catch (EOFException eOFException) {
            System.out.println("End of stream encountered");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        filterInputStream.close();
    }
}

