/*
 * Decompiled with CFR 0.152.
 */
package perenono.util.zip.decompress;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class GZipDecompress {
    public static int BUFFER_SIZE = 10000;

    public static String decompress(String string) throws NullPointerException, IOException, SecurityException {
        File file = GZipDecompress.decompress(new File(string));
        return file.getAbsolutePath();
    }

    public static void decompress(String string, String string2) throws NullPointerException, IOException, SecurityException {
        GZipDecompress.decompress(new File(string), new File(string2));
    }

    public static File decompress(File file) throws NullPointerException, IOException, SecurityException {
        String string = file.getAbsolutePath();
        int n = string.toLowerCase().lastIndexOf(".gz");
        string = string.substring(0, n);
        File file2 = new File(string);
        GZipDecompress.decompress(file, file2);
        return file2;
    }

    public static void decompress(File file, File file2) throws NullPointerException, IOException, SecurityException {
        GZipDecompress.decompress(new FileInputStream(file), file2);
    }

    public static void decompress(InputStream inputStream, File file) throws NullPointerException, IOException, SecurityException {
        DataInputStream dataInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            if (file.exists() || file.createNewFile()) {
                byte[] byArray = new byte[BUFFER_SIZE];
                int n = 0;
                dataInputStream = new DataInputStream(new GZIPInputStream(inputStream));
                filterOutputStream = new DataOutputStream(new FileOutputStream(file));
                while (dataInputStream.available() == 1) {
                    n = dataInputStream.read(byArray, 0, BUFFER_SIZE);
                    ((DataOutputStream)filterOutputStream).write(byArray, 0, n);
                }
            }
        }
        catch (EOFException eOFException) {
            System.out.println("End of stream encountered");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (filterOutputStream != null) {
            filterOutputStream.close();
        }
    }
}

