/*
 * Decompiled with CFR 0.152.
 */
package perenono.util.zip.decompress;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipDecompress {
    public static int BUFFER_SIZE = 10000;

    public static void decompress(String string) throws NullPointerException, IOException, SecurityException {
        File file = new File(string);
        ZipDecompress.decompress(file, file.getParentFile());
    }

    public static void decompress(String string, String string2) throws NullPointerException, IOException, SecurityException {
        ZipDecompress.decompress(new File(string), new File(string2));
    }

    public static void decompress(File file) throws NullPointerException, IOException, SecurityException {
        ZipDecompress.decompress(file, file.getParentFile());
    }

    public static void decompress(File file, File file2) throws NullPointerException, IOException, SecurityException {
        if (file2 == null) {
            file2 = new File(".");
        } else if (!file2.exists()) {
            file2.mkdirs();
        } else if (!file2.isDirectory()) {
            throw new IOException("output dir is not valid");
        }
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            String string2 = string.replace('/', File.separatorChar);
            File file3 = new File(file2.getAbsolutePath() + File.separator + string2);
            if (string2.charAt(string2.length() - 1) == File.separatorChar) continue;
            File file4 = new File(file3.getAbsolutePath().substring(0, file3.getAbsolutePath().lastIndexOf(File.separatorChar)));
            if (!file4.exists()) {
                file4.mkdirs();
            }
            file3.createNewFile();
            ZipDecompress.copy(zipFile.getInputStream(zipEntry), file3);
        }
    }

    private static void copy(InputStream inputStream, File file) throws NullPointerException, IOException, SecurityException {
        FilterInputStream filterInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            if (file.exists() || file.createNewFile()) {
                byte[] byArray = new byte[BUFFER_SIZE];
                int n = 0;
                filterInputStream = new DataInputStream(inputStream);
                filterOutputStream = new DataOutputStream(new FileOutputStream(file));
                while (filterInputStream.available() > 0) {
                    n = ((DataInputStream)filterInputStream).read(byArray, 0, BUFFER_SIZE);
                    ((DataOutputStream)filterOutputStream).write(byArray, 0, n);
                }
            }
        }
        catch (EOFException eOFException) {
            System.out.println("End of stream encountered");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        filterInputStream.close();
        if (filterOutputStream != null) {
            filterOutputStream.close();
        }
    }
}

