import perenono.util.zip.decompress.*;
import java.io.*;
import java.net.*;

/**
* main class of Jzipper
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
* @version 0.5a
* @see this application is distributed under GPL licence
*/
public class Jzipper
{
public static boolean DEBUG = false;

/**
* main function, they receive the option in parameter
*  line command format:
*	Jzipper <command> <option> <archive name> <file to add | dir or file to extract>
*  command:
*	-d	decompress
*	-c	compress
*	-a	add file to a an archive ( just for zip archive )
*	-h	display help and stop the program
*  option
*	-v	verbose mode
*	-g	compress in gzip ( if more file to add, each file give a compress file )
*	
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
* @version 0.5a
* @see this class is distributed under GPL licence
*/
public static void main(String[] args)
{
int param_cur = 0;
String archive = null;
String[] files = null;

boolean compress = false;
boolean decompress = false;
boolean add = false;
boolean gzip=false, help=false;

while(param_cur<args.length)
	{
	if(args[param_cur].compareTo("-v")==0) 
		{
		DEBUG =true;
		}
	else if(args[param_cur].compareTo("-h")==0)
		{
		help =true;
		break;
		}
	else if(args[param_cur].compareTo("-d")==0)
		{
		decompress = true;
		}
	else if(args[param_cur].compareTo("-c")==0)
		{
		compress = true;
		}
	else if(args[param_cur].compareTo("-a")==0)
		{
		add = true;
		}
	else if(args[param_cur].compareTo("-g")==0)
		{
		gzip = true;
		}
	else break;
	param_cur++;
	}

//--------------------------------------------------------------------------------
//display the help message
if(help || param_cur>=args.length)
	{
	try{
		URL url = (ClassLoader.getSystemClassLoader()).getResource("help.txt");
		System.out.println(url);
		DataInputStream file = new DataInputStream(url.openStream());
		while(file.available()>0)
			{
			String temp = file.readLine();
			if(temp!=null) System.out.println(temp);
			}
	}catch(Exception ex){System.out.println("erreur: "+ex.getMessage());ex.printStackTrace();}
	System.exit(0);
	}
//--------------------------------------------------------------------------------
	
//--------------------------------------------------------------------------------
//get the archive name and the name of file to add
archive = args[param_cur];
param_cur++;

files = new String[args.length-param_cur];
for(int i=0;i<files.length && param_cur<args.length;i++)
	{
	files[i] = args[param_cur];
	param_cur++;
	}
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//test if the data are ok
File archiveFile = new File(archive);
if(decompress && !archiveFile.exists()) 
	{
	if(DEBUG) System.out.println("Error: \""+archive+"\" does not exist");
	return;
	}
File[] filesFile = new File[files.length];
for(int i=0;i<files.length;i++)
	{
	filesFile[i] = new File(files[i]);
	if(compress && !filesFile[i].exists())
		{
		System.out.println("Error: \""+files[i]+"\" does not exist");
		return;
		}
	}
//--------------------------------------------------------------------------------

Noyau noyau = new Noyau();
if(decompress) noyau.decompress(archiveFile, filesFile);
else if(compress) noyau.compress(archiveFile, filesFile);
//else if(add) noyau.addFiles(archiveFile, filesFile);
else System.out.println("veuillez indiquer une action (-h pour afficher l'aide)");
}

}
