package perenono.util.zip.compress;

import java.io.*;
import java.util.zip.GZIPOutputStream;

/**
* class GZipDecompress is use to decompress a gzip file too easyly
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
* @version 1.0
* @see this class is distributed under LGPL licence
*/
public class GZipCompress
{
/**
* it's the size of the buffer used to write into the output file
*/
public static int BUFFER_SIZE = 10000;

/**
* compress _fileInput data into the file named _fileOutput
* @param _fileInput gzip file
* @param _fileOutput the compressed file
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static void compress(String _fileOutput, String _fileInput) throws NullPointerException , IOException, SecurityException
{
	compress(new File(_fileOutput), new File(_fileInput));
}

/**
* compress _fileInput data into the file named _fileOutput
* @param _fileInput gzip file
* @param _fileOutput the compressed file
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static void compress(File _fileOutput, File _fileInput) throws NullPointerException , IOException, SecurityException
{
if(_fileOutput.exists() || _fileOutput.createNewFile())
	compress(new FileOutputStream(_fileOutput), _fileInput);	
}

/**
* compress _fluxCompress data into the file named _fileOutput
* @param _fluxCompress gzip data
* @param _fileOutput the compressed file
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static void compress(OutputStream _fluxCompress, File _fileInput) throws NullPointerException , IOException, SecurityException
{
	DataInputStream in = null;
	DataOutputStream  out = null;
	GZIPOutputStream gzip = null;
	
	try{

	byte[] temp = new byte[BUFFER_SIZE];
	int size = 0;
	in = new DataInputStream(new FileInputStream(_fileInput));
	gzip = new GZIPOutputStream(_fluxCompress);
	out = new DataOutputStream(gzip);

	while(in.available() > 0 )
		{
		size = in.read(temp,0,BUFFER_SIZE);
		out.write(temp,0,size);
		}
        
        } catch(EOFException ex) {System.out.println("End of stream encountered");}
        catch(IndexOutOfBoundsException ex) { /*fin normal du program*/ }

	if(out!=null) 
		{
		out.close();
		gzip.finish();
		}
}

}