package perenono.util.zip.compress;

import java.io.*;
import java.util.zip.*;
import java.util.Enumeration;

/**
* class ZipCompress is use to compress a zip file too easyly
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
* @version 1.0
* @see this class is distributed under LGPL licence
*/
public class ZipCompress
{
/**
* it's the size of the buffer used to write into the output file
*/
public static int BUFFER_SIZE = 10000;

/**
* compress _fileInput data into the file named _fileOutput
* @param _fileInput zip file
* @param _dirOutput the files to compressed
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static void compress(String _fileOutput, String[] _filesInput) throws NullPointerException , IOException, SecurityException
{
	File[] ff = new File[_filesInput.length];
	for(int i=0;i<ff.length;i++)
		{
		ff[i] = new File(_filesInput[i]);
		}
	compress(new File(_fileOutput), ff);
}

/**
* compress _fileInput data into the file named _fileOutput
* @param _fileInput zip file
* @param _dirOutput the files to compressed
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static void compress(File _fileOutput, File[] _filesInput) throws NullPointerException , IOException, SecurityException
{
if(_fileOutput.exists() || _fileOutput.createNewFile())
	{
	ZipOutputStream fluxOutput = new ZipOutputStream(new FileOutputStream(_fileOutput));

	compress(fluxOutput, _fileOutput, _filesInput, "");
	
	fluxOutput.close();
	}
}


/**
* compress _fileInput data into the file named _fileOutput
* @param _fileOutput zip file
* @param _filesInput the files to compressed
* @param _dir the dir to write in zip
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
private static void compress(ZipOutputStream _fluxOutput, File _fileOutput, File[] _filesInput, String dir) throws NullPointerException , IOException, SecurityException
{
	for(int i=0;i<_filesInput.length;i++)
		{
		if(_filesInput[i].isFile())
			{
			if((_fileOutput.getCanonicalPath()).compareTo(_filesInput[i].getCanonicalPath())!=0)
				{
				ZipEntry zipe = new ZipEntry(dir+_filesInput[i].getName());
				_fluxOutput.putNextEntry(zipe);
				copy(_fluxOutput,_filesInput[i]);
				_fluxOutput.closeEntry();
				}
			}
		else	{
			String temp = null;
			if((_filesInput[i].getName()).compareTo(".")==0 || (_filesInput[i].getName()).compareTo("..")==0) temp="";
			else if(dir.compareTo(".")==0 || dir.compareTo("..")==0 || dir.compareTo("./")==0 || dir.compareTo("../")==0) temp = _filesInput[i].getName()+"/"; 
			else temp = dir+_filesInput[i].getName()+"/";
			compress(_fluxOutput, _fileOutput, _filesInput[i].listFiles(), temp);
			}
		}
}


/**
* copy the flux into the file
* @param _fluxFile file data
* @param _fileOutput the file where put the decompressed data
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
private static void copy(OutputStream _fluxFile, File _filesInput) throws NullPointerException , IOException, SecurityException
{
	DataInputStream in = null;
	DataOutputStream  out = null;
	
	try{

	byte[] temp = new byte[BUFFER_SIZE];
	int size = 0;

	in = new DataInputStream(new FileInputStream(_filesInput));

	out = new DataOutputStream(_fluxFile);

	while(in.available() > 0 )
		{
		size = in.read(temp,0,BUFFER_SIZE);
		out.write(temp,0,size);
		}
        
        } catch(EOFException ex) {System.out.println("End of stream encountered");}
        catch(IndexOutOfBoundsException ex) { /*fin normal du program*/ }

	in.close();
}

}