package perenono.util.zip.decompress;

import java.io.*;
import java.util.zip.GZIPInputStream;

/**
* class GZipDecompress is use to decompress a gzip file too easyly
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
* @version 1.0
* @see this class is distributed under LGPL licence
*/
public class GZipDecompress
{
/**
* it's the size of the buffer used to write into the output file
*/
public static int BUFFER_SIZE = 10000;

/**
* class GZipDecompress is use to decompress a gzip file too easyly
* @param _fileInput name of the gzip file ( the output file have the same name but without ".gz" extension. Example nono.txt.gz -> nono.txt)
* @return the name of the decompressed file
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static String decompress(String _fileInput) throws NullPointerException , IOException, SecurityException
{
	File tmp = decompress(new File(_fileInput));
	return tmp.getAbsolutePath();
}

/**
* decompress _fileInput data into the file named _fileOutput
* @param _fileInput gzip file
* @param _fileOutput the decompressed file
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static void decompress(String _fileInput, String _fileOutput) throws NullPointerException , IOException, SecurityException
{
	decompress(new File(_fileInput), new File(_fileOutput));
}

/**
* decompress _fileInput and return the file decompressed
* @param _fileInput gzip file ( the output file have the same name but without ".gz" extension. Example nono.txt.gz -> nono.txt)
* @return file decompressed
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static File decompress(File _fileInput) throws NullPointerException , IOException, SecurityException
{
	String fileName = _fileInput.getAbsolutePath();
	int pos = (fileName.toLowerCase()).lastIndexOf(".gz");
	fileName = fileName.substring(0,pos);
	File tmp = new File(fileName);
	decompress(_fileInput, tmp);
	return tmp;
}

/**
* decompress _fileInput data into the file named _fileOutput
* @param _fileInput gzip file
* @param _fileOutput the decompressed file
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static void decompress(File _fileInput, File _fileOutput) throws NullPointerException , IOException, SecurityException
{
	decompress(new FileInputStream(_fileInput), _fileOutput);	
}

/**
* decompress _fluxCompress data into the file named _fileOutput
* @param _fluxCompress gzip data
* @param _fileOutput the decompressed file
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static void decompress(InputStream _fluxCompress, File _fileOutput) throws NullPointerException , IOException, SecurityException
{
	DataInputStream in = null;
	DataOutputStream  out = null;
	
	try{
	if(_fileOutput.exists() || _fileOutput.createNewFile())
		{
		byte[] temp = new byte[BUFFER_SIZE];
		int size = 0;
		in = new DataInputStream(new GZIPInputStream(_fluxCompress));

		out = new DataOutputStream(new FileOutputStream(_fileOutput));

		while(in.available() == 1 )
			{
			size = in.read(temp,0,BUFFER_SIZE);
			out.write(temp,0,size);
			}
		}
        
        } catch(EOFException ex) {System.out.println("End of stream encountered");}
        catch(IndexOutOfBoundsException ex) { /*fin normal du program*/ }

	if(out!=null) out.close();
}

}