package perenono.util.zip.decompress;

import java.io.*;
import java.util.zip.*;
import java.util.Enumeration;

/**
* class ZipDecompress is use to decompress a gzip file too easyly
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
* @version 1.0
* @see this class is distributed under LGPL licence
*/
public class ZipDecompress
{
/**
* it's the size of the buffer used to write into the output file
*/
public static int BUFFER_SIZE = 10000;

/**
* decompress the zip file _fileInput in the same directory
* @param _fileInput name of the zip file
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static void decompress(String _fileInput) throws NullPointerException , IOException, SecurityException
{
	File tmp = new File(_fileInput);
	decompress(tmp,tmp.getParentFile());	
}

/**
* decompress _fileInput data into the file named _fileOutput
* @param _fileInput zip file
* @param _dirOutput the directory where put the decompressed files
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static void decompress(String _fileInput, String _dirOutput) throws NullPointerException , IOException, SecurityException
{
	decompress(new File(_fileInput), new File(_dirOutput));
}

/**
* decompress the zip file _fileInput in the same directory
* @param _fileInput zip file to decompress
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static void decompress(File _fileInput) throws NullPointerException , IOException, SecurityException
{
	decompress(_fileInput,_fileInput.getParentFile());	
}

/**
* decompress _fileInput data into the file named _fileOutput
* @param _fileInput zip file
* @param _dirOutput the directory where put the decompressed files
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
public static void decompress(File _fileInput, File _dirOutput) throws NullPointerException , IOException, SecurityException
{
	if(_dirOutput==null) _dirOutput = new File(".");
	else if(!_dirOutput.exists()) _dirOutput.mkdirs();
	else if(!_dirOutput.isDirectory()) throw new IOException("output dir is not valid");

ZipFile file = new ZipFile(_fileInput);
for (Enumeration e = file.entries() ; e.hasMoreElements() ;)
	{
	ZipEntry zipe = (ZipEntry)(e.nextElement());
	String fileName = zipe.getName();
	String fileName2 = fileName.replace('/',File.separatorChar);

        File tmp = new File(_dirOutput.getAbsolutePath()+File.separator+fileName2);
        File tmp2;
	if(fileName2.charAt(fileName2.length()-1)!=File.separatorChar) 
		{
		tmp2 = new File((tmp.getAbsolutePath()).substring(0,(tmp.getAbsolutePath()).lastIndexOf(File.separatorChar)));
		if(!tmp2.exists())
			{
			tmp2.mkdirs();
			}
		}
	else continue; //on nous indique simplement le dossier  crer, on saute
	
	tmp.createNewFile();
	copy(file.getInputStream(zipe),tmp);
	}
}

/**
* copy the flux into the file
* @param _fluxFile file data
* @param _fileOutput the file where put the decompressed data
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
*/
private static void copy(InputStream _fluxFile, File _fileOutput) throws NullPointerException , IOException, SecurityException
{
	DataInputStream in = null;
	DataOutputStream  out = null;
	
	try{
	if(_fileOutput.exists() || _fileOutput.createNewFile())
		{
		byte[] temp = new byte[BUFFER_SIZE];
		int size = 0;
		in = new DataInputStream(_fluxFile);

		out = new DataOutputStream(new FileOutputStream(_fileOutput));

		while(in.available() > 0 )
			{
			size = in.read(temp,0,BUFFER_SIZE);
			out.write(temp,0,size);
			}
		}
        
        } catch(EOFException ex) {System.out.println("End of stream encountered");}
        catch(IndexOutOfBoundsException ex) { /*fin normal du program*/ }

	in.close();
	if(out!=null) out.close();
}

}