package perenono.lib.pnm;

import java.awt.*;
import java.io.*;
import java.awt.image.*;
import java.util.*;

/**
* class PNMCodec is use to save an image in binary PPM
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
* @version 0.8
* @see this class is distributed under LGPL licence
*/
public class PNMCodec
{
private static boolean DEBUG = false;
private DataOutputStream flux;
private int width=0, height=0;
private int[] image;
private boolean save = false; //pour eviter les double sauvegarde

public void saveImage(Image image, File name) throws Exception
{
save = true;
if(DEBUG) System.out.println("sauvegarde name: "+name.getAbsolutePath());
flux = new DataOutputStream(new FileOutputStream(name));
ImageProducer product = image.getSource();
product.startProduction(new PNMConsumer());
}

/////////////////////////////////////////////////////////////////////////////////////
/**
* PNMConsumer is use to receive information of the image and save this
*/
public class PNMConsumer implements ImageConsumer
{
	
public void imageComplete(int status)
{
if(DEBUG) System.out.println("imageComplete");
if(save && status==ImageConsumer.STATICIMAGEDONE)
	{
try{
	if(DEBUG) System.out.println("ecriture de l'en-tete");
	flux.writeByte('P');flux.writeByte('6');flux.writeByte('\n');
	byte[] bytes = (new String(width+" "+height)).getBytes();
	for(int i=0;i<bytes.length;i++) flux.writeByte(bytes[i]);
	flux.writeByte('\n');
	flux.writeByte('2');flux.writeByte('5');flux.writeByte('5');flux.writeByte('\n');
	int size = width*height;
	for(int i=0;i<size;i++)
		{
		flux.writeByte((byte)(image[i]>>16));
		flux.writeByte((byte)(image[i]>>8));
		flux.writeByte((byte)(image[i]));
		}
	flux.close();
}catch(Exception ex){}
	save = false;
	}
else if(status==ImageConsumer.IMAGEABORTED)System.out.println("image reading aborted");
else if(status==ImageConsumer.IMAGEERROR)System.out.println("error produce during the reading");
else if(status==ImageConsumer.SINGLEFRAME)System.out.println("SINGLEFRAME");
else if(status==ImageConsumer.SINGLEFRAMEDONE)System.out.println("SINGLEFRAMEDONE");
}
 
public void setColorModel(ColorModel model)
{
if(DEBUG) System.out.println("setColorModel: "+model);
}

public void setDimensions(int iwidth, int iheight)
{
width = iwidth;
height = iheight;
image = new int[iwidth*iheight];
}

public void setHints(int hintflags)
{
if(DEBUG) 
	{
	System.out.println("setHints");
	if(hintflags==ImageConsumer.RANDOMPIXELORDER) System.out.println("RANDOMPIXELORDER");
	else if(hintflags==ImageConsumer.TOPDOWNLEFTRIGHT) System.out.println("TOPDOWNLEFTRIGHT");
	else if(hintflags==ImageConsumer.COMPLETESCANLINES) System.out.println("COMPLETESCANLINES");
	else if(hintflags==ImageConsumer.SINGLEPASS) System.out.println("SINGLEPASS");
	else if(hintflags==ImageConsumer.SINGLEFRAME) System.out.println("SINGLEFRAME");
	}
}

public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize)
{
//if(DEBUG) System.out.println("setPixels1");
int[] temp = new int[pixels.length];
for(int i=0;i<pixels.length;i++)
	{
	temp[i]= pixels[i] + (pixels[i] << 8) + (pixels[i] << 16) + (0xFF << 24);
	}
setPixels(x,y,w,h,model,temp,off,scansize);
}

public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize)
{
//if(DEBUG) System.out.println("setPixels2");
for(int i=0;i<h;i++)
	{
	for(int j=0;j<w;j++)
		{
		int color = pixels[i*w+j];
//System.out.println(model.getBlue(color)+" "+model.getGreen(color)+" "+model.getRed(color));
		image[(y+i)*width+x+j]= model.getBlue(color)+(model.getGreen(color)<<8)+(model.getRed(color)<<16)+(0xFF << 24);
		}
	}
}

public void setProperties(Hashtable props)
{
if(DEBUG) System.out.println("setProperties "+props);
}
}

}