package perenono.lib.pnm;

import java.awt.*;
import java.awt.image.*;
import java.io.*;
import java.net.URL;
import java.util.Hashtable;
import java.util.Enumeration;

/**
* class PNMDecodec is use to read a pnm image ( PBM, PGM, PPM )
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
* @version 0.5
* @see this class is distributed under LGPL licence
*/
public class PNMDecodec extends Component implements ImageProducer
{
private static boolean DEBUG = false;

//mode du fichier
private boolean pbm=false;
private boolean pgm=false;
private boolean ppm=false;
//size
private int height=0,width=0;
private int size;
private int currentLine=0;
//mode de sauvegarde des pixel
private boolean binaire=false;
//intensite pour pgm et ppm
private int intensite=255;
//flux d'entree
private DataInputStream flux;
private URL file;
//image
private int[] imageLine;
//ImageConsumer
private Hashtable himc;

public PNMDecodec()
{
himc = new Hashtable(3);
}

/**
* it's call by the user to get an image
*/
public Image getImage(URL file) throws Exception
{
this.file = file;
return createImage(this);
}

public void addConsumer(ImageConsumer imc)
{
himc.put(imc,imc);
}

public boolean isConsumer(ImageConsumer imc)
{
if(himc.get(imc)!=null) return true;
else return false;
}

public void removeConsumer(ImageConsumer imc)
{
himc.remove(imc);
}

public void startProduction(ImageConsumer imc)
{
addConsumer(imc);
startProduction();
removeConsumer(imc);
}

public void requestTopDownLeftRightResend(ImageConsumer ic)
{
//ne fait rien pour le moment
System.out.println("requestTopDown :"+ic);
}

public void startProduction()
{
try{
flux = new DataInputStream(file.openStream());
readHeader();
if(DEBUG) System.out.println("lecture de l'entete");

for (Enumeration e = himc.keys() ; e.hasMoreElements() ;) 
	{
	ImageConsumer imc = (ImageConsumer)(e.nextElement());
	imc.setDimensions(width,height);
	size=width*height;
	imc.setColorModel(ColorModel.getRGBdefault());
	imc.setHints(ImageConsumer.TOPDOWNLEFTRIGHT );
	}
if(DEBUG) System.out.println("info de controle envoye");

readValue();
if(DEBUG) System.out.println("fin lecture");

for (Enumeration e = himc.keys() ; e.hasMoreElements() ;) ((ImageConsumer)(e.nextElement())).imageComplete(ImageConsumer.STATICIMAGEDONE);

}catch(Exception ex)
	{
	for (Enumeration e = himc.keys() ; e.hasMoreElements() ;) ((ImageConsumer)(e.nextElement())).imageComplete(ImageConsumer.IMAGEERROR );
	}
}

/**
* read the header of the file
*/
private void readHeader() throws Exception
{
if(DEBUG) System.out.println("readHeader");
pbm=false;
pgm=false;
ppm=false;
binaire=false;
int reste = 1;
String temp;
char test=' ';

while(reste>0 && flux.available()>0)
	{
	temp = flux.readLine();
	temp.trim();
	temp = temp.toUpperCase();
	if(temp!=null && temp.length()>1 && temp.charAt(0)!='#')
		{
		if(temp.length()>=2 && temp.charAt(0)=='P')
			{
			test = temp.charAt(1);
if(DEBUG) System.out.println("type "+test);
			//verification de la version du fichier
			if(test=='1' || test=='4') 
				{
				pbm=true;
				intensite=1; //pour faciliter la prise en compte
				}
			else if(test=='2' || test=='5') pgm=true;
			else if(test=='3' || test=='6') ppm=true;
			else throw new Exception("file not correct");
			
			if(test=='4' || test=='5' || test=='6') binaire=true;
			}
		reste--;
		}
	}
while(flux.available()>0)
	{
	char octet;
	do{
	  octet = (char)flux.readByte();
	}while(flux.available()>0 && octet!='#' && !(octet>='0' && octet<='9'));
	
	if(flux.available()<=0) ;//throws new Exception("incorrect");
	else if(octet=='#') skipLine();
	else	{
		//recuperation de la taille
		width=getNumber(octet);
		height=getNumber(' ');
if(DEBUG) System.out.println("taille "+width+" "+height);
		
		if((test=='2' || test=='3' || test=='5' || test=='6') && flux.available()>0)
			{
			intensite = getNumber(' ');
if(DEBUG) System.out.println("intensite "+intensite);
			}
		return ;
		}
	}
}

/**
* read the file while this is not the end of a file
*/
private void skipLine() throws Exception
{
if(DEBUG) System.out.println("skipLine");
while(flux.available()>0 && ((char)(flux.readByte()))!='\n');
}

/**
* read the next ascii number and convert this to an int 
*/
private int getNumber(char ioctet) throws Exception
{
if(DEBUG) System.out.println("getNumber");
int number=0;
char octet=ioctet;
boolean valid = false;

do{
	number*=10;
	switch(octet)
		{
		case '0' : break;
		case '1' : number+=1;valid=true;break;
		case '2' : number+=2;valid=true;break;
		case '3' : number+=3;valid=true;break;
		case '4' : number+=4;valid=true;break;
		case '5' : number+=5;valid=true;break;
		case '6' : number+=6;valid=true;break;
		case '7' : number+=7;valid=true;break;
		case '8' : number+=8;valid=true;break;
		case '9' : number+=9;valid=true;break;
		default : if(valid) return number/10;
		}
	octet=(char)(flux.readByte());
}while(flux.available()>0);
return number;
}

/**
* choose the fonction to read the value with the information read in the header
*/
private void readValue()// throws Exception
{
try{
currentLine = 0;
if(pbm && binaire) readBitValue();
else if(pgm && binaire) readByteValue();
else if(ppm && binaire) readBytesValue();
else if(pbm || pgm) readStringValue();
else if(ppm) readStringsValue();
}catch(Exception ex){ex.printStackTrace();}
}

/**
* envoie des donnees
*/
private void envoie()
{
for (Enumeration e = himc.keys() ; e.hasMoreElements() ;)
	{
	((ImageConsumer)(e.nextElement())).setPixels(0,currentLine,width,1,ColorModel.getRGBdefault(),imageLine,0,1);
	}
}

//////////////////////////////////////////////////////////////////////////////////////
/**
* it is use to the binary PBM
*/
private void readBitValue() throws Exception
{
if(DEBUG) System.out.println("read bit value");
int pos=0;
int decal=0;
int filtre=0;

int val;
currentLine=0;
while(flux.available()>0 && currentLine<height)
    {
    imageLine = new int[width];
    while(flux.available()>0 && pos<width)
	{
	val = (int)(flux.readByte());
	filtre=128;
	decal=7;
	while(decal>=0)
		{
		imageLine[pos] = ((val & filtre)>>decal)*255;
		imageLine[pos]= imageLine[pos] + (imageLine[pos] << 8) + (imageLine[pos] << 16) + (0xFF << 24);
		pos++;
		filtre=(int)(filtre/2);
		decal--;
		}
	}
if(DEBUG) System.out.println("new ligne");
    pos=0;
    envoie();
    currentLine++;
    }
}

//////////////////////////////////////////////////////////////////////////////////////
/**
* it is use to read binary PGM
*/
private void readByteValue() throws Exception
{
float mult = 255/intensite;
if(DEBUG) System.out.println("read byte value");
int pos=0;
int val;
byte[] ligne = new byte[width];
currentLine=0;
while(flux.available()>0 && currentLine<height)
	{
	imageLine = new int[width];
	flux.read(ligne);
	while(flux.available()>0 && pos<width)
		{
		val = (int)((int)(ligne[pos])*mult);
		imageLine[pos]= val + (val << 8) + (val << 16) + (0xFF << 24);
		pos++;
		}
if(DEBUG) System.out.println("new ligne");
	envoie();
	currentLine++;
	pos=0;
	}
}

//////////////////////////////////////////////////////////////////////////////////////
/**
* it is use to read binary PPM
*/
private void readBytesValue() throws Exception
{
float mult = 255/intensite;
if(DEBUG) System.out.println("read bytes value intensite:"+mult);
int pos=0;
int red, green, blue;
byte[] ligne = new byte[width*3];
currentLine=0;
while(flux.available()>2 && currentLine<height)
	{
	imageLine = new int[width];
	flux.read(ligne);
	while(flux.available()>0 && pos<width)
		{
		red = (int)((int)(ligne[pos*3])*mult);
		green = (int)((int)(ligne[pos*3+1])*mult);
		blue = (int)((int)(ligne[pos*3+2])*mult);
		imageLine[pos]= blue + (green << 8) + (red << 16) + (0xFF << 24);
		pos++;
		}
if(DEBUG) System.out.println("new ligne");
	envoie();
	currentLine++;
	pos=0;
	}
}

//////////////////////////////////////////////////////////////////////////////////////
/**
* it is use to read ASCII PBM and PGM
*/
private void readStringValue() throws Exception
{
float mult = 255/intensite;
if(DEBUG) System.out.println("read string value avec intensite: "+mult);
int pos=0;
String temp;
int index=0;
currentLine=0;
while(flux.available()>0 && currentLine<height)
	{
	imageLine = new int[width];
	while(flux.available()>0 && pos<width)
		{
		temp=(flux.readLine()).trim();
		while(temp!=null && temp.length()>0 && pos<width)
			{
			index = temp.indexOf(' ');
			if(index>0)
				{
				imageLine[pos] = (int)(Integer.parseInt(temp.substring(0,index))*mult);
				temp = (temp.substring(index)).trim();
				}
			else if(index==-1)
				{
if(DEBUG) System.out.print("fin de ligne du fichier ligne"+currentLine+" pos "+pos);
				imageLine[pos] = (int)(Integer.parseInt(temp)*mult);
				temp=null;
				}
			imageLine[pos]=imageLine[pos] + (imageLine[pos] << 8) + (imageLine[pos] << 16) + (0xFF << 24);
			pos++;
			}
if(DEBUG) System.out.println("new ligne");
		}
	envoie();
	currentLine++;
	pos=0;
	}
}

//////////////////////////////////////////////////////////////////////////////////////
/**
* it is use to read ASCII PPM
*/
private void readStringsValue() throws Exception
{
float mult = 255/intensite;
if(DEBUG) System.out.println("read strings value intensite:"+mult);
int pos=0;
int red=0, green=0;
int suiv=0, val=0;
String temp;
int index=0;
currentLine=0;
imageLine = new int[width];
while(flux.available()>0 && currentLine<height)
	{
	while(flux.available()>0 && pos<width)
		{
		temp=(flux.readLine()).trim();
		while(temp!=null && temp.length()>0 && pos<width)
			{
			index = temp.indexOf(' ');
			if(index>0)
				{
				val = (int)(Integer.parseInt(temp.substring(0,index))*mult);
				temp = (temp.substring(index)).trim();
				}
			else if(index==-1)
				{
if(DEBUG) System.out.print("fin de ligne du fichier");
				val = (int)(Integer.parseInt(temp)*mult);
				temp=null;
				}
		//test for understand the utility of the value
			if(suiv==0)
				{
				red=val;
				suiv++;
				}
			else if(suiv==1)
				{
				green=val;
				suiv++;
				}
			else	{	
				imageLine[pos]=val + (green << 8) + (red << 16) + (0xFF << 24);
				pos++;
				suiv=0;		
				}
			}
		}
if(DEBUG) System.out.println("new ligne");
	envoie();
	currentLine++;
	pos=0;
	}
}

}