package perenono.lib.pnm;

import java.awt.*;
import java.io.File;
import java.net.URL;

/**
* class PNMFilter is use to get or save an image
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
* @version 0.8
* @see this class is distributed under LGPL licence
*/
public class PNMFilter extends Component
{
private static boolean DEBUG = false;

///////////////procedure de recuperation///////////////////
public static Image getImage(String name) throws Exception
{
return getImage(new File(name));
}

public static Image getImage(File name) throws Exception
{
return getImage(new URL("file:/"+name.getAbsolutePath()));
}

public static Image getImage(URL name) throws Exception
{
if(DEBUG) System.out.println("url: "+name.toString());
PNMDecodec decodec = new PNMDecodec();
return decodec.getImage(name);
}

///////////////procedure de sauvegarde/////////////////////
//////////////sauvegarde toujours en PNM///////////////////
public static void saveImage(Image image, String name) throws Exception
{
saveImage(image, new File(name));
}

public static void saveImage(Image image, File name) throws Exception
{
if(DEBUG) System.out.println("sauvegarde file: "+name.getAbsolutePath());
(new PNMCodec()).saveImage(image, name);
}
}