import java.awt.*;
import java.awt.Font;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.*;
import java.awt.event.*;
//import java.awt.MediaTracker;
import java.awt.Component;
import java.awt.print.*;

/**
* applet pour visualiser des images
* recoit en parametre :
*	width_ : nombre de pixels en longueur de l'ecran
*	height_ : nombre de pixels en hauteur de l'ecran
*	number : nombre d'images passes en parametre
*	image<num> : nom de l'image <num>  afficher
*	background : couleur de fond format: 123-256-14
*
* @author <a href="mailto:noel.perez@pere-nono.com">Perez Nol</a><br> web site:<a href="http://www.pere-nono.com">http://www.pere-nono.com</a>
* @version 1.0
* @see this class is distributed under GPL licence
*/
public class visionneuse extends java.applet.Applet implements MouseListener, MouseMotionListener, ActionListener//, Printable
{

Vector nom_image; //vecteur contenant l'ensemble des noms d'images
Image temp; //image courante
PopupMenu choix_act;

boolean avancer,reculer; //indique a tout moment s'il y a un rollback sur le bouton
int num_image=0; //image a afficher
int num_cour =0; //empeche un reaffichage de l'image trop souvent
double zoom =1; //zoom courant
int longueur,hauteur; //longueur et hauteur de la zone d'affichage

int x,y; //coordonnee du point haut gauche de la zone d'affichage de l'image
int long_image,haut_image; //longueur et hauteur de l'image

int screenWidth,screenHeight; //resolution d'affichage de l'ecran, utilis pour la fentre de plein ecran
int appletWidth,appletHeight;

/**
* initialisation des variable et recuperation des parametres
*/
public void init()
{
setBackground(Color.black);

appletWidth=getSize().width;
appletHeight=getSize().height;
screenWidth=Integer.parseInt(getParameter("width_"));
screenHeight=Integer.parseInt(getParameter("height_"));

setBackground(getColor(getParameter("background")));

/**
* recuperation des noms des images a afficher
*/
nom_image = new Vector();
int number=Integer.parseInt(getParameter("number"));
for(int i=1;i<=number;i++)
	{
	nom_image.addElement(getParameter("image"+i));
	}

/**
* reglage pour un affichage 400*400
*/
longueur=appletWidth-50;
hauteur=appletHeight-100;
x=25;
y=25;

avancer=false;
reculer=false;

//menu popup
choix_act = new PopupMenu("actions");
MenuItem avancer = new MenuItem("avancer");
avancer.setName("avancer");
avancer.addActionListener(this);
MenuItem reculer = new MenuItem("reculer");
reculer.setName("reculer");
reculer.addActionListener(this);
/*
MenuItem imprimer = new MenuItem("imprimer");
imprimer.setName("imprimer");
imprimer.addActionListener(this);
*/
MenuItem full = new MenuItem("plein ecran");
full.setName("full");
full.addActionListener(this);
choix_act.add(avancer);
choix_act.add(reculer);
choix_act.addSeparator();
choix_act.add(full);
//choix_act.add(imprimer);
add(choix_act);

addMouseListener(this);
addMouseMotionListener(this);
}

private Color getColor(String couleur)
{
int red, green, blue;
int posdeb, posfin;
posdeb = 0;
posfin = couleur.indexOf('-');
red = Integer.parseInt(couleur.substring(posdeb,posfin));
posdeb = posfin+1;
posfin = couleur.indexOf('-',posdeb);
green = Integer.parseInt(couleur.substring(posdeb,posfin));
blue = Integer.parseInt(couleur.substring(posfin+1,couleur.length()));
return new Color(red,green,blue);
}

/**
* affiche le cadre et l'image
*/
public void paint(Graphics g)
{
//cadre
g.setColor(Color.gray);
g.drawRoundRect(appletWidth-201,appletHeight-101,200,100,50,50);
g.setColor(Color.lightGray);
g.fillRoundRect(appletWidth-200,appletHeight-100,200,99,50,50);
g.setColor(Color.gray);
g.fillRoundRect(0,0,appletWidth,appletHeight-49,50,50);
g.setColor(Color.lightGray);
g.fillRoundRect(1,1,appletWidth,appletHeight-51,50,50);

g.setColor(Color.gray);
g.drawRoundRect(appletWidth-171,appletHeight-41,50,31,10,10); //bouton reculer
g.drawRoundRect(appletWidth-81,appletHeight-41,50,31,10,10); //bouton avancer
g.setColor(Color.lightGray);
g.fillRoundRect(appletWidth-170,appletHeight-40,50,30,10,10); //bouton reculer
g.fillRoundRect(appletWidth-80,appletHeight-40,50,30,10,10); //bouton avancer

///texte des boutons
g.setFont(new Font("TimesRoman", Font.PLAIN,12));
if (reculer) g.setColor(Color.red);
else g.setColor(Color.black);
g.drawString("reculer",appletWidth-160,appletHeight-20);
if (avancer) g.setColor(Color.red);
else g.setColor(Color.black);
g.drawString("avancer",appletWidth-70,appletHeight-20);

//zone d'image
g.setColor(Color.white);
g.fillRect(25,25,longueur,hauteur);

//image
charger((String)(nom_image.elementAt(num_image)));
long_image=temp.getWidth(this);
haut_image=temp.getHeight(this);
g.drawImage(temp,x+(int)((longueur-(long_image*zoom))/2),y+(int)((hauteur-(haut_image*zoom))/2),(int)(long_image*zoom),(int)(haut_image*zoom),this);
}

/**
* affiche juste la zone de l'image
*/
public void update(Graphics g)
{
///texte des boutons
g.setFont(new Font("TimesRoman", Font.PLAIN,12));
if (reculer) g.setColor(Color.red);
else g.setColor(Color.black);
g.drawString("reculer",appletWidth-160,appletHeight-20);
if (avancer) g.setColor(Color.red);
else g.setColor(Color.black);
g.drawString("avancer",appletWidth-70,appletHeight-20);

if (num_cour!=num_image)
	{
	int temp_long,temp_haut;
	double temp_zoom;

	//image
	temp_zoom=zoom;
	charger((String)(nom_image.elementAt(num_image)));
	temp_long=temp.getWidth(this);
	temp_haut=temp.getHeight(this);

	if((long_image*temp_zoom)>(temp_long*zoom) || (haut_image*temp_zoom)>(temp_haut*zoom))
		{
		//zone d'image
		g.setColor(Color.white);
		g.fillRect(25,25,longueur,hauteur);
		}

	long_image=temp_long;
	haut_image=temp_haut;
	g.drawImage(temp,x+(int)((longueur-(temp_long*zoom))/2),y+(int)((hauteur-(temp_haut*zoom))/2),(int)(temp_long*zoom),(int)(temp_haut*zoom),this);
	num_cour=num_image;
	}
}

/**
* recupere un image en fonction du nom et recherche le zoom le plus adapt
*/
public void charger(String nom)
{
temp = getImage(getCodeBase(),nom);
MediaTracker mt = new MediaTracker(this);
mt.addImage(temp,0);
try{
mt.waitForID(0);
}catch(InterruptedException e){}

if (((double)longueur/(double)temp.getWidth(this))>((double)hauteur/(double)temp.getHeight(this)))
	{
	zoom=((double)hauteur/(double)temp.getHeight(this));
	}
else {zoom=((double)longueur/(double)temp.getWidth(this));}
}

public void mouseClicked(MouseEvent e){
if (e.getX()>appletWidth-170 && e.getX()<appletWidth-120 && e.getY()>appletHeight-40 && e.getY()<appletHeight-10)
	{
	reculer();
	}
else if (e.getX()>appletWidth-80 && e.getX()<appletWidth-30 && e.getY()>appletHeight-40 && e.getY()<appletHeight-10)
	{
	avancer();
	}
}

public void mousePressed(MouseEvent e){
if (e.getX()>25 && e.getX()<appletWidth-25 && e.getY()>25 && e.getY()<appletHeight-75 && e.isMetaDown())
	{
	choix_act.show(this,e.getX(),e.getY());
	}
}

public void mouseReleased(MouseEvent e){}
public void mouseEntered(MouseEvent e){}
public void mouseExited(MouseEvent e){}
public void mouseDragged(MouseEvent e){}

public void mouseMoved(MouseEvent e){
if(e.getX()>appletWidth-170 && e.getX()<appletWidth-120 && e.getY()>appletHeight-40 && e.getY()<appletHeight-10)
	{
	if (!reculer)
		{
		avancer=false;
		reculer=true;
		repaint();
		}
	}
else if(e.getX()>appletWidth-80 && e.getX()<appletWidth-30 && e.getY()>appletHeight-40 && e.getY()<appletHeight-10)
	{
	if (!avancer)
		{
		avancer=true;
		reculer=false;
		repaint();
		}
	}
else if(avancer || reculer)
	{
	avancer=false;
	reculer=false;
	repaint();
	} 
}

/**
* affiche l'image suivante, s'il n'y en a pas cela prend la premiere
*/
public void avancer()
{
if (num_image<nom_image.size()-1) num_image+=1;
else num_image =0;
repaint();
}

/**
* affiche l'image precedente, s'il n'y en a pas affiche la derniere
*/
public void reculer()
{
if (num_image>0) num_image-=1;
else num_image = nom_image.size()-1;
repaint();
}

/*
public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException
{
int m_maxNumPage = 1;

if (pageIndex >= m_maxNumPage || temp == null)
      return NO_SUCH_PAGE;

pg.translate((int)pageFormat.getImageableX(), 
(int)pageFormat.getImageableY());
int wPage = (int)pageFormat.getImageableWidth();
int hPage = (int)pageFormat.getImageableHeight();

int w = temp.getWidth(this);
int h = temp.getHeight(this);
if (w == 0 || h == 0)
      return NO_SUCH_PAGE;
int nCol = Math.max((int)Math.ceil((double)w/wPage), 1);
int nRow = Math.max((int)Math.ceil((double)h/hPage), 1);
m_maxNumPage = nCol*nRow;

int iCol = pageIndex % nCol;
int iRow = pageIndex / nCol;
int x = iCol*wPage;
int y = iRow*hPage;
int wImage = Math.min(wPage, w-x);
int hImage = Math.min(hPage, h-y);

pg.drawImage(temp, 0, 0, wImage, hImage, x, y, x+wImage, y+hImage, this);
System.gc();
        
return PAGE_EXISTS;
}
*/

/**
* gestion des actions
*/
public void actionPerformed(ActionEvent e){
String name=((MenuItem)e.getSource()).getName();
if(name=="imprimer")
	{
/*
	try {
		PrinterJob prnJob = PrinterJob.getPrinterJob();
		prnJob.setPrintable(this);
		if (!prnJob.printDialog())
		       	return;
		prnJob.print();
	}catch (PrinterException ex)
	    {
	    ex.printStackTrace();
	    System.err.println("Printing error: "+ex.toString());
	    }
*/
	}
else if(name=="full")
	{
	fenetre fen = new fenetre(new Frame(), temp,this,"plein ecran");
	fen.setSize(screenWidth,screenHeight);
	fen.setVisible(true);
	fen.toFront();
	}
else if(name=="avancer")
	{
	avancer();
	}
else if(name=="reculer")
	{
	reculer();
	}
}

/**
* classe utilis pour le plein ecran
*/
public class fenetre extends Window implements ActionListener, MouseListener{
Image im;
double zoom2 = 1;
PopupMenu choix_act2;

fenetre(Frame fen, Image temp,visionneuse f_princ, String title)
{
super(fen);
im = temp;

//menu popup
choix_act2 = new PopupMenu("actions");
MenuItem close = new MenuItem("fermer");
close.setName("fermer");
close.addActionListener(this);
choix_act2.add(close);
add(choix_act2);

addMouseListener(this);
best_zoom();
}

/**
* calcul le zoom pour que l'image soit afficher en plein ecran 
*/
public void best_zoom()
{
zoom2 = (((double)screenWidth/(double)long_image)>((double)(screenHeight)/(double)haut_image)) ? ((double)(screenHeight)/(double)haut_image) : ((double)screenWidth/(double)long_image);
}

public void paint(Graphics g)
{
g.drawImage(temp,(int)((screenWidth/2)-(long_image*zoom2/2)),(int)((screenHeight/2)-(haut_image*zoom2/2)),(int)(long_image*zoom2),(int)(haut_image*zoom2),this);
}

public void actionPerformed(ActionEvent e){
System.out.println("action demande");
String name=((MenuItem)e.getSource()).getName();
if(name=="fermer")
	{
	this.setVisible(false);
	this.dispose();
	}
}

public void mousePressed(MouseEvent e) {choix_act2.show(this,e.getX(),e.getY());}
public void mouseReleased(MouseEvent e){}
public void mouseEntered(MouseEvent e){}
public void mouseExited(MouseEvent e){}
public void mouseClicked(MouseEvent e){}
}

}