/*
 *
 * GWIC
 * (c) Joonas Lehtinen (jole@jole.fi), TUCS, 1998
 * 
 * Java port (c) Sasha Chukov (sash@tspu.edu.ru), 1999
 * Progressive version  0.99b
 *
 */

import java.io.*;

class header 
{
	int   /*U32*/	magic;
	short /*U16*/	version;            /* Version number */
	short /*U16*/	iwidth,iheight;     /* Dimensions of the original image */
	short /*U16*/	dpi;                /* Dots Per Inch, 0 if unspecified */
	int   /*U32*/	ccbsc;              /* Crominace Channel BPP Scaling Coefficient
										   ccbpp = (bbp * ccbsc) >> 8 */
	byte  /*BYTE*/	cm;                 /* Color model used */
	byte  /*BYTE*/	transform;          /* Transform used */
	short /*U16*/	width,height;       /* Dimensions of the coefficient matrix */
	byte  /*BYTE*/	levelsY;            /* Number of Y levels in pyramid composition */
	byte  /*BYTE*/	levelsUV;           /* Number of U&V levels in pyramid composition */
	byte[]/*BYTE*/	bpp = new byte[4];  /* Bits per pixel on each color channel */
	byte[]/*BYTE*/	n = new byte[4];    /* Starting scanning level on a color channel */

	private byte readByte(DataInputStream inS)
	{
		try{
			return inS.readByte();
		}catch(Exception e){
			System.out.println("Oshibka chteniya byte");
			return 0;
		}
	}

	private short readShort(DataInputStream inS)
	{
		short a = (short)(readByte(inS) & 0xFF);
		short b = (short) (((int)readByte(inS) & 0xFF)<< 8);
		return (short)(a | b);
	}

	private int readInt(DataInputStream inS)
	{
		int a = (readShort(inS) & 0xFFFF);
		a = a | (((int)readShort(inS) & 0xFFFF) << 16);
		return a;
	}

	public boolean readHeader(DataInputStream inS)
	{
		try{
			magic   = readInt(inS);
			version = readShort(inS);
			iwidth  = readShort(inS);
			iheight = readShort(inS);
			dpi     = readShort(inS);
			ccbsc   = readInt(inS);
			cm      = readByte(inS);
			transform = readByte(inS);
			width   = readShort(inS);
			height  = readShort(inS);
			levelsY = readByte(inS);
			levelsUV= readByte(inS);
			bpp[0]  = readByte(inS);
			bpp[1]  = readByte(inS);
			bpp[2]  = readByte(inS);
			bpp[3]  = readByte(inS);
			n[0]    = readByte(inS);
			n[1]    = readByte(inS);
			n[2]    = readByte(inS);
			n[3]    = readByte(inS);
		}catch(Exception e){
			System.out.println("Oshibka chteniya headera (header.java)");
			return false;
		}
		return true;
	}
}
