/*
 *
 * GWIC
 * (c) Joonas Lehtinen (jole@jole.fi), TUCS, 1998
 * 
 * Java port (c) Sasha Chukov (sash@tspu.edu.ru), 1999
 * Progressive version  0.99b
 *
 */

class transform 
{
	private final static int TR_DAUB2 = 0;	/* Daubechies transform */
	private final static int TR_B97   = 1;	/* Biorthogonal B97 transform with
											   circular vector boudaries */

	/* Daubechies filters, N = 2 (Vetterli: Subband.., p.260) */
	private final static float tr_daub2_high[] = {
		.129409522f, .22414386f, -.8365163f, .48296291f };
	private final static float tr_daub2_low[] = { 
		.48296291f, .8365163f, .22414386f, -.129409522f };

	/* Biorthogonal B97 filters */
	private final static float tr_b97_f_high[] = { 
		0.788485f, -0.418092f, -0.040690f,  0.064539f, 0.0f, 0.0f };
	private final static float tr_b97_i_high[] = { 
		0.852699f,  -0.377403f, -0.110624f, 0.023849f, 0.037829f, 0.0f };
	private final static float tr_b97_f_low[] = { 
		0.852699f,  0.377403f, -0.110624f, -0.023849f, 0.037829f, 0.0f };
	private final static float tr_b97_i_low[] = { 
		0.788485f, 0.418092f, -0.040690f,  -0.064539f, 0.0f, 0.0f };

	public float[] convert_matrix_from_int(int[] /*U32*/buf, int len)
	{
		float[] ob;
		int i;
		int /*U32*/ f;

		ob = new float[len];

		for(i=0; i<len; i++) {
			f = buf[i];
			if ((0x80000000 & f) != 0) ob[i] = (int) -(f & 0x7FFFFFFF);
			else ob[i] = f;
//			ob[i] = f;
		}
		return ob;
	}


/* Inverse-filter float vector in as defined by transform */
	private void inverse_filter_vector(float[] in, int in_offs,
			float[] out, int out_offs, int l, byte transform)
	{
		int i,j,k,h,n,m;

		switch(transform) {
		case TR_DAUB2:
			h=l >> 1;
			for(i=0;i<l;i++) out[out_offs + i]=0.0f;
			for (i=0; i<h; i++) {
				for (j=0; j<4; j++) {
					k = (i<<1)+j; if (k>=l) k-=l; 
					out[out_offs + k] += in[in_offs + i]*tr_daub2_low[j] +
						in[in_offs + i+h]*tr_daub2_high[j];
				}
			}
			break;
		case TR_B97:
			h=l>>1;
			for(i=0;i<l;i++) out[out_offs + i]=0.0f;
			for (i=0; i<h; i++) {
				k = i<<1;
				out[out_offs + k] += in[in_offs + i] * tr_b97_i_low[0];
				out[out_offs + k+1] += in[in_offs + i+h] * tr_b97_i_high[0];
				for (j=1; j<5; j++) {
					n = k + j; if (n>=l) n-=l; 
					m = k - j; if (m<0) m+=l; 
					out[out_offs + n] += in[in_offs + i] * tr_b97_i_low[j];
					out[out_offs + m] += in[in_offs + i] * tr_b97_i_low[j];
					n = k + j +1; if (n>=l) n-=l; 
					m = k - j +1; if (m<0) m+=l; 
					out[out_offs + n] += in[in_offs + i+h] * tr_b97_i_high[j];
					out[out_offs + m] += in[in_offs + i+h] * tr_b97_i_high[j];
				}
			}
			break;
		default: 
			System.out.println("Unsupported transform requested");
		}
	}

	public void inverse_transform(float[] table, int width, int height, byte transform)
	{
		int w,h,i,j;
		float[] ibuf,obuf;
		float[] p;
		int p_offs = 0;
		int obuf_offs = 0, ibuf_offs = 0;

		w = width; h = height;
		ibuf = new float[(w>h?w:h)+20];
		obuf = new float[(w>h?w:h)+20];
		ibuf_offs += 10; obuf_offs += 10;

		while(((((w>>1)|(h>>1))&1) == 0) && (w>>1)>=8 && (h>>1)>=8) { w=w>>1; h=h>>1; }
  
		/* levels */
		while(w<=width && h<=height) {
			/* cols */
			for(i=0; i<w; i++) {
				for(p_offs = i, j=0; j<h;j++,p_offs += width)
					ibuf[ibuf_offs+j] = table[p_offs];
				inverse_filter_vector(ibuf,ibuf_offs, obuf,obuf_offs, h,transform);
				for(p_offs = i, j=0; j<h;j++,p_offs += width)
					table[p_offs] = obuf[obuf_offs+j];
			}

			/* rows */
			for(j=0; j<h; j++) {
				for(p_offs = j*width, i=0; i<w; i++, p_offs++)
					ibuf[ibuf_offs + i] = table[p_offs];
				inverse_filter_vector(ibuf,ibuf_offs,obuf,obuf_offs,w,transform);
				for(p_offs = j*width, i=0; i<w; i++, p_offs++)
					table[p_offs] = obuf[obuf_offs+i];
			}

			w = w << 1 ; h = h << 1; 
		}

		ibuf_offs -= 10; obuf_offs -= 10;
//		free(ibuf); free(obuf);
	}
}

