/*
 *
 * GWIC
 * (c) Joonas Lehtinen (jole@jole.fi), TUCS, 1998
 * Java port (c) Sasha Chukov (sash@tspu.edu.ru), 1999
 *
 */

import java.io.*;

class coder 
{
	private final int ESC = 0xff;	/* escape        */
	private final int STUFF = 0x00;	/* escape escape */
	private final int SDNORM = 0x02;/* normal stripe data end */
	private final int MASK = 0x7fffffff;
	private final int SIGN = 0x80000000;

	private final int SSIGN = 0;
	private final int SCONT = 1;
	private final int SBIT  = 2;
	private final int SNEWSIG = 3;  /* Size 32 */
	private final int SORISIGH = 35; /* Size 32 */
	private final int SORISIGD = 67; /* Size 32 */
	private final int SORISIGV = 99; /* Size 32 */
	private final int STOPLEVEL = 131;

	private final int TOTALSTATES = 132;

	private long   BytesInQM=0;		/* Number of bytes read  at decoding stage */
	public long    BytesOutQM=0;	/* Number of bytes write at encoding stage */
	private int    EscMode=1;
	private long   EndCodePos=0;

	private int /*U32*/  c;		/* Coding register */
	private int /*U16*/ a;		/* Size of coding interval*/
	private int stflag;			/* Flag to inhibit first write */
	private int nzero;			/* Potential trailing zeros */
	private int sc;				/* Number of FF bytes */
	private int buffer;			/* Bits buffered for output or input */
	private int pacfeed;			/* End-of-Code-Flag ?? */
	private int ct;				/* Shift counter */
	private DataInputStream decodefile;

	private int[] cstate;		/* State tables */
	private int[] mps;			/* MPS tables */


	private final static char /*U16*/ lsz[] = {
		0x5a1d,0x2586,0x1114,0x080b,0x03d8,0x01da,0x00e5,0x006f,0x0036,
		0x001a,0x000d,0x0006,0x0003,0x0001,0x5a7f,0x3f25,0x2cf2,0x207c,
		0x17b9,0x1182,0x0cef,0x09a1,0x072f,0x055c,0x0406,0x0303,0x0240,
		0x01b1,0x0144,0x00f5,0x00b7,0x008a,0x0068,0x004e,0x003b,0x002c,
		0x5ae1,0x484c,0x3a0d,0x2ef1,0x261f,0x1f33,0x19a8,0x1518,0x1177,
		0x0e74,0x0bfb,0x09f8,0x0861,0x0706,0x05cd,0x04de,0x040f,0x0363,
		0x02d4,0x025c,0x01f8,0x01a4,0x0160,0x0125,0x00f6,0x00cb,0x00ab,
		0x008f,0x5b12,0x4d04,0x412c,0x37d8,0x2fe8,0x293c,0x2379,0x1edf,
		0x1aa9,0x174e,0x1424,0x119c,0x0f6b,0x0d51,0x0bb6,0x0a40,0x5832,
		0x4d1c,0x438e,0x3bdd,0x34ee,0x2eae,0x299a,0x2516,0x5570,0x4ca9,
		0x44d9,0x3e22,0x3824,0x32b4,0x2e17,0x56a8,0x4f46,0x47e5,0x41cf,
		0x3c3d,0x375e,0x5231,0x4c0f,0x4639,0x415e,0x5627,0x50e7,0x4b85,
		0x5597,0x504f,0x5a10,0x5522,0x59eb,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0000,0x0000};

	private final static int swtch[] = {
		1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   1,   0,
		0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		1,   0,   0,   0,   0,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0};

	private final static int nmps[] = {
		1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  13,  15,
		16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,
		31,  32,  33,  34,  35,   9,  37,  38,  39,  40,  41,  42,  43,  44,  45,
		46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,
		61,  62,  63,  32,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,
		76,  77,  78,  79,  48,  81,  82,  83,  84,  85,  86,  87,  71,  89,  90,
		91,  92,  93,  94,  86,  96,  97,  98,  99, 100,  93, 102, 103, 104,  99,
		106, 107, 103, 109, 107, 111, 109, 111,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0};

	private final static int nlps[] = {
		1,  14,  16,  18,  20,  23,  25,  28,  30,  33,  35,   9,  10,  12,  15,
		36,  38,  39,  40,  42,  43,  45,  46,  48,  49,  51,  52,  54,  56,  57,
		59,  60,  62,  63,  32,  33,  37,  64,  65,  67,  68,  69,  70,  72,  73,
		74,  75,  77,  78,  79,  48,  50,  50,  51,  52,  53,  54,  55,  56,  57,
		58,  59,  61,  61,  65,  80,  81,  82,  83,  84,  86,  87,  87,  72,  72,
		74,  74,  75,  77,  77,  80,  88,  89,  90,  91,  92,  93,  86,  88,  95,
		96,  97,  99,  99,  93,  95, 101, 102, 103, 104,  99, 105, 106, 107, 103,
		105, 108, 109, 110, 111, 110, 112, 112,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0};


	// from zerotree.c
	private int stop_immediately;


	public coder()
	{
	}

	private byte /*BYTE*/ InputByteFromFile(DataInputStream f)
	{
		int x = 0;

		if(pacfeed != 0) return(0);

		if (EscMode != 0){
			try{
				x = f.readByte(); //getc(f);
//System.out.println("::" + ((int)x & 0xFF));
			} catch(Exception e) {
				System.out.println("InputByteFromFile() #1 - Error!");
			}
			if((x & 0xFF) != ESC) { BytesInQM++; return((byte)x); }
			try{
				switch(f.readByte()){
					case STUFF:   BytesInQM++; return((byte)ESC); /* ESC STUFF => ESC */
					case SDNORM:  pacfeed = 1; return(0);
//					case EOF:     System.out.println("EOF detected.");// exit(-1);
					default:      System.out.println("Unsupported ESC-code detected.");// exit(-1);
				}
			} catch(Exception e){
				System.out.println("InputByteFromFile() #2 - Error!");
			}
//System.out.print("Puk...");
			return(0);
		} else {
//			if(EndCodePos==ftell(f)) {
//				pacfeed = 1;
//				return(0); /* end-of-code */ 
//			} else {
				try{
					x = f.readByte();
				} catch(Exception e) {
					System.out.println("InputByteFromFile() #3 - Error!");
				}
				BytesInQM++;
				return((byte)x);
//			}
		}
	}

	private void ByteIn(DataInputStream f)
	{
		int /*U32*/ temp;

		temp = (int)/*(U32)*/ ((int) InputByteFromFile(f) & 0xFF) << 8;

//System.out.println("ByteIn -> " + temp);

		c += temp;
		ct = 8;
	}

	private void InitModelQM(int MaxStates)
	{
		int p;

		cstate = new int[MaxStates];
		mps    = new int[MaxStates];
		if( cstate == null ){
			System.out.println("cstate[" + MaxStates + "] is out of memory");
			//exit(-1);
		}
		if( mps == null ){
			System.out.println("mps[" + MaxStates + "] is out of memory");
			//exit(-1);
		}

		BytesInQM = BytesOutQM = 0;

		for(p=0 ; p<MaxStates ; p++){
			mps[p]          = 0;
			cstate[p]       = 0;
		}

	}

	public void start_decoding(DataInputStream f, int maxstates)
	{
		InitModelQM(maxstates);

		/* static reinitialization for sequential use*/
		c=0;               /* Coding register */
		a=0;               /* Size of coding interval*/
		stflag=0;          /* Flag to inhibit first write */
		nzero=0;           /* Potential trailing zeros */
		sc=0;              /* Number of FF bytes */
		buffer=0;          /* Bits buffered for output or input */
		pacfeed=0;         /* End-of-Code-Flag ?? */
		ct=0;              /* Shift counter */
  
//System.out.println("INIT decoding");
  
		c = 0; ByteIn(f); c <<= 8; ByteIn(f); c <<= 8; ByteIn(f);
		a = 0;
  
		/* Note: it is assumed Short = 16 bits. In case of 32 bit use this: */
		a = 0x10000;
  
		decodefile = f;
	}

	void stop_decoding()
	{
	}

	heap2d gen_2d_heap(int[] /*U32*/ buf, int width, int height, int levels)
	{
		int c1,c2,c3,c4,c,size,h,i,j,k,l,m,w,lev,b,t;
		heap2d heap;
//		byte[] /*BYTE*/ p;
		int	p;
		int n=0;

		heap = new heap2d();

		for(size=0, i=1; i<=levels; i++) size += (width>>i)*(height>>i);
		size += (width>>levels)*(height>>levels);

		/* Allocate and initialize heap structure */
		heap.heap = new byte[size+1];
		heap.lines = new int[height * /*sizeof(U32 *)*/ 4];
		heap.width = width; 
		heap.height = height;
		heap.levels = levels;
		h = height>>levels; 
		w = width>>levels;
		i = h<<1;
	//	p = heap.heap;
		p = 0;
		for(j=0; j<height; j++) {
			heap.lines[j] = p;
			if (j>=i) {
				h = h << 1;
				w = w << 1;
				i += h;
			}
			p += w;
		}
		/* Prepare the bottom level */
		w = width>>1; h=height>>1; k=h*width;
		for(j=0; j<h; j++) for(i=0; i<w; i++) {
			l = i+j*width;
			c1 = buf[w+l] & MASK;
			c2 = buf[k+l] & MASK;
			c3 = buf[w+k+l] & MASK;
			c = c1>c2 ? (c1>c3?c1:c3) : (c2>c3?c2:c3);
			for(l=0;c>0;l++,c=c>>1); 
			heap.heap[heap.lines[h+j] + i] = (byte)l;
		}
		/* Prepare the middle levels */
		for (lev=1; lev < levels; lev++) {
			w = width>>(lev+1); h=height>>(lev+1); k=h*width;
			for(j=0; j<h; j++) for(i=0; i<w; i++) {
				l = i+j*width;
				c1 = buf[w+l] & MASK;
				c2 = buf[k+l] & MASK;
				c3 = buf[w+k+l] & MASK;
				c = c1>c2 ? (c1>c3?c1:c3) : (c2>c3?c2:c3);
				for(l=0;c>0;l++,c=c>>1); c=l;
				l = heap.heap[heap.lines[(h<<1)+ (j<<1)] + (i<<1)]; if(l>c)c=l;
				l = heap.heap[heap.lines[(h<<1)+ (j<<1)] + (i<<1)+1]; if(l>c)c=l;
				l = heap.heap[heap.lines[(h<<1)+ (j<<1)+1] + (i<<1)]; if(l>c)c=l;
				l = heap.heap[heap.lines[(h<<1)+ (j<<1)+1] + (i<<1)+1]; if(l>c)c=l;
				heap.heap[heap.lines[h+j] + i] = (byte)c;
			}
		}

		/* Prepare the top level */
		w = width>>levels; h=height>>levels; k=h*width;
		for(j=0; j<h; j++) for(i=0; i<w; i++) {
			c = buf[i+j*width] & MASK;
			for(l=0;c>0;l++,c=c>>1); c=l;
			l = heap.heap[heap.lines[h+j]+i];
			heap.heap[heap.lines[j] + i] =(byte) (l>c ? l : c);
		}
  
		/* Calculate max n */
		h = height>>levels; w = width>>levels;
		for (j=0; j<h; j++) for (i=0; i<w; i++) 
			n = n > heap.heap[heap.lines[j]+i] ? n : heap.heap[heap.lines[j]+i];
		heap.max = n;

		return heap;
	}

	//coder.c
	int decode_bit(int state)
	{
		int bb,sb;
		int bit;

		a -= lsz[cstate[state]];
		if ((char )((c>>16) & 0xFFFF) < a) {
//System.out.println("#1. c = " + c + "; a = " + (int)a);
			if(a < 0x8000) {
//System.out.println("#1.1");
				if(a < lsz[cstate[state]]) { 
//System.out.println("#1.1.a");
					bit = 1-mps[state]; 
					mps[state] = ((swtch[cstate[state]] != 0 )? 1-mps[state]: mps[state]);
					cstate[state]  = nlps[cstate[state]]; 
				} else { 
//System.out.println("#1.1.b");
					bit = mps[state]; cstate[state]  = nmps[cstate[state]]; 
				}
				do {
					if(ct==0) ByteIn(decodefile);
					a <<= 1; c <<= 1; ct--; 
				} while(a < 0x8000 );
//				RENORMD(codedecodefile);
			}
			else { bit = mps[state];
//System.out.println("bit = mps");
			}
		} else {
//System.out.println("#2.c = " + c + "; a = " + (int)a);
			if(a<lsz[cstate[state]]) { 
//System.out.println("#2.a");
				bit= mps[state];
				c -= (/*U32*/ long)a<<16; a=lsz[cstate[state]]; 
				cstate[state]  = nmps[cstate[state]]; 
				do {
					if(ct==0) ByteIn(decodefile);
					a <<= 1; c <<= 1; ct--; 
				} while(a < 0x8000 );
//				RENORMD(codedecodefile);
			} else { 
//System.out.println("#2.b");
				bit = 1-mps[state];
				c -= (/*U32*/ long)a<<16; 
				a=lsz[cstate[state]]; 
				mps[state] = (swtch[cstate[state]] != 0)? 1-mps[state]: mps[state]; 
				cstate[state]  = nlps[cstate[state]]; 
				do {
					if(ct==0) ByteIn(decodefile);
					a <<= 1; c <<= 1; ct--; 
				} while(a < 0x8000);
//				RENORMD(codedecodefile);
			} 
		}
  
		return bit;
	}

	//from zerotree.c
	private int cdc()
	{
		if (stop_immediately != 0) return 0;
		if (decode_bit(SCONT) == 0) {
			stop_immediately = 1;
			return 0;
		}
		return 1;
	}

	//from zerotree.c
	void scandecode(int[] /*U32*/ coeff, int x, int y,
			heap2d h, int n, int l,int fx, int fy,int lw,int lh)
	{
		int hv = h.heap[h.lines[y] + x];
		int state;
		int[] /*U32*/ p = coeff;
		int /*U32*/ nthbit = 1 << (n-1);
		int ch,cv,cd;
		int ib=0;
		int poff;

		if (cdc() != 0) {

			if (hv == 0) { /* There is something worth coding on this bitlevel n */
				state = SNEWSIG + l;
				if ((l != 0) && (h.heap[h.lines[fy] + fx] == n)) state += 16;
				ib = decode_bit(state);
			}

			if (ib != 0) hv = h.heap[h.lines[y]+x] = (byte) n;

			if (hv != 0) {
				/* Scan children */
				if (l != 0) {

					poff = h.width * y + x;
					ch = p[poff]; cd = p[poff+lw]; cv = p[poff+lw-lh*h.width];

					/* HORIZONTAL */
					if (ch != 0)
						p[poff] = ch = (ch&(~nthbit)) | ((decode_bit(SBIT) != 0)? nthbit : 0) | (nthbit>>1);
					else {
						state  = SORISIGH + l;
						if ((cd&MASK) >= (nthbit<<1) || (cv&MASK) >= (nthbit<<1)) state +=16;
						if (decode_bit(state) != 0) 
							p[poff] = ch = ((decode_bit(SSIGN) != 0) ? SIGN : 0) | nthbit | (nthbit>>1);
					}
					/* DIAGONAL */
					if (cd != 0)
						p[poff+lw] = cd = (cd&(~nthbit)) | ((decode_bit(SBIT) != 0) ? nthbit : 0) | (nthbit>>1);
					else {
						state  = SORISIGD + l;
						if ((ch&MASK) >= nthbit || (cv&MASK) >= (nthbit<<1)) state +=16;
						if(decode_bit(state) != 0) 
							p[poff+lw] = cd = ((decode_bit(SSIGN) != 0) ? SIGN : 0) | nthbit | (nthbit>>1);
					}

					/* VERTICAL */
					if (cv != 0)
						p[poff+lw-lh*h.width] = cv = (cv&(~nthbit)) | ((decode_bit(SBIT) != 0) ? nthbit : 0) | (nthbit>>1);
					else {
						state  = SORISIGV + l;
						if ((ch&MASK) >= nthbit || (cd&MASK) >= nthbit) state +=16;
						if(decode_bit(state) != 0) 
							p[poff+lw-lh*h.width] = cv = ((decode_bit(SSIGN) != 0)? SIGN : 0) | nthbit | (nthbit>>1);
					}

					if ((y<<1)<h.height) {
						scandecode(coeff,x<<1,y<<1,h,n,l+1,x,y,lw<<1,lh<<1);
						scandecode(coeff,(x<<1)+1,y<<1,h,n,l+1,x,y,lw<<1,lh<<1);
						scandecode(coeff,x<<1,(y<<1)+1,h,n,l+1,x,y,lw<<1,lh<<1);
						scandecode(coeff,(x<<1)+1,(y<<1)+1,h,n,l+1,x,y,lw<<1,lh<<1);
					}
				} else {
					poff = h.width * y + x;
					ch = p[poff]; 

					/* TOPLEVEL */
					if (ch != 0)
						p[poff] = ch = (ch&(~nthbit)) | ((decode_bit(SBIT) != 0) ? nthbit : 0) | (nthbit>>1);
					else 
						if(decode_bit(STOPLEVEL) != 0) 
							p[poff] = ch = ((decode_bit(SSIGN) != 0)? SIGN : 0) | nthbit | (nthbit>>1);
    
					scandecode(coeff,x,y+lh,h,n,1,x,y,lw,lh);
				}
			}
		}

	}

	//from zerotree.c
	int[] /*U32*/ zerotree_decode(int width, int height, int levels, int n)
	{
		int[] /*U32*/ coeff, p;
		int w,h,i,j;
		heap2d heap;
		stop_immediately = 0;

//System.out.println("init coeff...");

		coeff = new int[width * height];
//System.out.println("init coeff done...");
  
		for(i = width * height - 1; i >= 0; i--) coeff[i] = 0;

//System.out.println("gen_2d_heap()...");
		heap = gen_2d_heap(coeff, width, height, levels);  
//System.out.println("done...");
		w = width >> levels;
		h = height >> levels;
  
		for(;n>0 && stop_immediately == 0; n--) 
			for (j=0; j<h && stop_immediately == 0; j++) 
				for (i=0; i<w && stop_immediately == 0; i++){
//System.out.println("w= " + i + "; h= " + j);
					scandecode(coeff,i,j,heap,n,0,-1,-1,w,h);
//System.out.println("stop_immediately = " + stop_immediately);
//System.out.println("n = " + n);
		}

		return coeff;
	}
}

