/*
 *
 * GWIC
 * (c) Joonas Lehtinen (jole@jole.fi), TUCS, 1998
 * Java port (c) Sasha Chukov (sash@tspu.edu.ru), 1999
 *
 */

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.image.*;

import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

public class decrunch
{
	public final static byte CM_GRAY = 0;	/* Gray scale image 8 intel-byte-order */
	public final static byte CM_GRAY_DEEPSPARC = 1;/* Gray scale image with >8 bpp and sparc
								byte-order */
	public final static byte CM_RGB24 = 2;	/* 24bit packed RGB color */

	public static boolean debug = false;

	final static int TOTALSTATES = 132;
	DataInputStream inS;
	private boolean fLH = false;
	header head;
	
	/*
	 * 樠 
	 */	
	public boolean initDecompressor(DataInputStream iS)
	{
	if (fLH) return false;
	    try{
		inS = iS;
		head = new header();
		if(debug) System.out.println("Chitayu header!");
		if (!head.readHeader(inS)) {
			System.out.println("Errorr!");
			return false;
		}
		fLH = true;
		return true;
	    } catch(Exception e){
		fLH = false;
		return false;
	    }
	}
	
	/*
	 * 砥 ਭ ⨭
	 */
	public int getWidth()
	{
	    if(fLH) return head.iwidth;
	    else return -1;
	}

	/*
	 * 砥  ⨭
	 */
	public int getHeight()
	{
	    if(fLH) return head.iheight;
	    else return -1;
	}

	/*
	 * 砥 ⨯ ⨭
	 * 0 - GrayScale
	 * 1 - ???
	 * 2 - YUV422
	 */
	public int getImageType()
	{
	    if(fLH) return head.cm;
	    else return -1;
	}

	/*
	 *
	 *  ⨭  த,  ⮬   
	 *  ᠭ    த   ଠ!
	 *
	 */
	public ImageProducer Decompressor()
	{
		int[] coeffY = null, coeffU = null, coeffV = null;
		float[] fY = null, fU = null, fV = null;
		int[] dst;
		float R, G, B;

		if (!fLH) return null;

		try{
			coder cdr = new coder();
			cdr.start_decoding(inS, TOTALSTATES);

			coeffY = cdr.zerotree_decode(head.width, head.height, head.levelsY, head.n[0]);
			if (head.cm == decrunch.CM_RGB24){
				coeffU = cdr.zerotree_decode(head.width / 2, head.height, head.levelsUV, head.n[1]);
				coeffV = cdr.zerotree_decode(head.width / 2, head.height, head.levelsUV, head.n[2]);
			}
			cdr.stop_decoding();

			transform trans = new transform();
			fY = trans.convert_matrix_from_int(coeffY, head.width * head.height);
			if (head.cm == decrunch.CM_RGB24){
				fU = trans.convert_matrix_from_int(coeffU, head.width * head.height / 2);
				fV = trans.convert_matrix_from_int(coeffV, head.width * head.height / 2);
			}

			trans.inverse_transform(fY, head.width, head.height, head.transform);
			if (head.cm == decrunch.CM_RGB24){
				trans.inverse_transform(fU, head.width / 2, head.height, head.transform);
				trans.inverse_transform(fV, head.width / 2, head.height, head.transform);
			}

			dst = new int[head.width * head.height];

			switch(head.cm){
				case decrunch.CM_GRAY:
					float c;
					for (int i = 0; i < head.width * head.height; i++){
						c = fY[i];
						if (c > 255) c = 255;
						else if (c < 0) c = 0;
						R = G = B = c;
						dst[i] = (int)B + ((int)G << 8) + ((int)R << 16) + (0xFF << 24);
					}
					break;
				case decrunch.CM_RGB24:
					int j = 0;
					float U = 0, V = 0;
					for (int i = 0; i < head.width * head.height; i++){
						if (j % 2 == 0) {
							U = fU[j / 2];
							V = fV[j / 2];
						}
						j++;

						R = (float)(fY[i] + 0.95617 * U + 0.62143 * V);
						G = (float)(fY[i] - 0.27269 * U - 0.64681 * V);
						B = (float)(fY[i] - 1.10374 * U + 1.70062 * V);

						if (R > 255) R = 255;
						else if (R < 0) R = 0;
						if (G > 255) G = 255;
						else if (G < 0) G = 0;
						if (B > 255) B = 255;
						else if (B < 0) B = 0;
						dst[i] = ((int)B) + (((int)G) << 8) + (((int)R) << 16) + (0xFF << 24);
					}
					break;
				default:
					System.out.println("Unsupported color mode!");
					fLH = false;
					return null;
			}

			fLH = false;
			return new MemoryImageSource((int)head.iwidth, (int)head.iheight,
						ColorModel.getRGBdefault(),
						dst, 0, (int)head.width);
		}catch(Exception e){
			System.out.println("IO error!");
			fLH = false;
			return null;
		}
	}

	public decrunch()
	{
		fLH = false;
	}

	public String Version()
	{
		return "Name: GNU Java wavelet image decruncher v0.99\n" +
		       "GWIC Java port (c) Sasha Chukov (sash@tspu.edu.ru), 1999\n" +
		       "GWIC (c) Joonas Lehtinen (jole@jole.fi), TUCS, 1998";
	}

}
