/*
 *
 * GWIC
 *
 * (c) Joonas Lehtinen (jole@jole.fi), TUCS, 1998
 *
 * modification for rgb2yuv & yuv2rgb
 * for color model YUV422 by Sasha Chukov
 *
 */

#include "gwic.h"

/* Convert and round float matrix to sign-int format */
U32 *convert_matrix_from_float(float *buf, int len)
{
  U32 *ob;
  int i; 
  float f;
  int x;

  MALLOC(ob,len * 4);


  for(i=0; i<len; i++) {
    x = *buf++;
    if (x<0) *(ob+i) = SIGN | -x;
    else *(ob+i) = x;
  }
  
  return ob;
}
  
/* Convert sing-int formatted matrix to floats */
float *convert_matrix_from_int(U32 *buf, int len)
{
  float *ob;
  int i;
  U32 f;

  MALLOC(ob,len * sizeof(float));

  for(i=0; i<len; i++) {
    f = *buf++;
    if (SIGN & f) *(ob+i) = (int) -(f & MASK);
    else *(ob+i) = f;
  }
  return ob;
}

/*
   Convert packed pixel 24-bit color representation to 
   YUV422 plane representation 
   len is lenght of one plane, so the lenght (no. elems.) 
   of the buffer is 2*len , so as length U and V planes
   is half of Y plane 
 */
void convert_matrix_from_24bc_packed_to_yuv_planes(float *buf, int len)
{
  float *tmp;
  int len3 = len * 2; /* len3 = len_y + len_u + len_v */ 
  float *p = buf;
  float *y; 
  float *u;
  float *v;
  int i;
  float _u, _v;

  MALLOC(tmp,len3*sizeof(float));
  y = tmp; u = y+len; v = u+len/2;

  for(i = 0; i<len; i++) {
    float r = *p++;
    float g = *p++;
    float b = *p++;

    *y++ = 0.299 * r + 0.587 * g + 0.114 * b;

    if (i % 2 == 1) {
      _u = *u++ = ((*u) + (0.596 * r - 0.274 * g - 0.322 * b)) / 2;
      _v = *v++ = ((*v) + (0.211 * r - 0.523 * g + 0.312 * b)) / 2;
    } else {
      *u = 0.596 * r - 0.274 * g - 0.322 * b;
      *v = 0.211 * r - 0.523 * g + 0.312 * b; 
    }
  }
  
  /* Copy from tmp back into original buffer */
  for(i = 0 ; i<len3; i++) *buf++ = *(tmp+i);
  free(tmp);
}


/* Convert YUV422 plane representation to
   packed pixel 24-bit color representation to 
   len is lenght of one plane, so the lenght (no. elems.) 
   of the buffer is 3*len */

void convert_matrix_from_to_yuv_planes_24bc_packed(float *buf, int len)
{
  float *tmp;
  int len3 = len * 3;
  float *p;
  float *y;
  float *u;
  float *v;
  int i;
  float r,g,b;
  
  MALLOC(tmp,len3*sizeof(float));
  y = buf; u = y+len; v = u+len/2; p=tmp;

  for(i = 0; i<len; i++) {
    /*R*/ r = *p++ = *y + .95617 * *u + .62143 * *v;
    /*G*/ g = *p++ = *y - 0.27269 * *u - .64681 * *v;
    if (i % 2 == 1) /*B*/ b = *p++ = (*y++) - 1.10374 * (*u++) + 1.70062 * (*v++);
    else /*B*/ b = *p++ = (*y++) - 1.10374 * (*u) + 1.70062 * (*v);
  }
  
  /* Copy from tmp back into original buffer */
  for(i = 0 ; i<len3; i++) *buf++ = *(tmp+i);
  free(tmp);
}
