/*
 *
 * GWIC
 *
 * (c) Joonas Lehtinen (jole@jole.fi), TUCS, 1998
 *
 */

#include "gwic.h"

/* Load PNM file. Coverts dimensions to be more reasonable */
void load_pnm(FILE *in, float **pic, int *width, int *height, 
	      int *orig_width, int *orig_height, int *maxcolor, 
	      BYTE *colormode) {
  char str[256];
  char c;
  int i,j,h,w,oh,ow,c1,c2;
  float *p, *g;

  /* Checking in file type */
  if (getc(in) != 'P') TERMINATE("Input is not PGM ?");
  
  switch(getc(in)) {
  case '5' : *colormode = CM_GRAY; break;
  case '6' : *colormode = CM_RGB24; break;
  default : 
    TERMINATE("PGM or PPM must be in RAW format");
  }
  if (getc(in) != '\n') TERMINATE("Weird format!");

  // Get width, weight and adjust then accordingly
  for(str[0]='#';str[0]=='#';) for(i=0,c=1;c&&c!='\n';i++) str[i]=c=fgetc(in);
  sscanf(str,"%i %i\n",&ow,&oh);
  if (ow<1 || oh<1) TERMINATE("PNM Width and Height must be > 0");
  w=ow>256 ? (ow+15) & 0xfffffff0 : (ow+7) & 0xfffffff8;
  h=oh>256 ? (oh+15) & 0xfffffff0 : (oh+7) & 0xfffffff8;
  *height = h; *width = w;
  *orig_height = oh; *orig_width = ow;
  

  // Allocate space
  switch(*colormode) {
  case CM_GRAY: MALLOC(*pic,w*h*sizeof(float)); break;
  case CM_RGB24: MALLOC(*pic,w*h*sizeof(float)*3); break;
  }

  // Get maxcolor
  fscanf(in,"%i\n",maxcolor);
  if ((*maxcolor >= 256) && (*colormode == CM_RGB24)) {
    TERMINATE("Only 8bpp / color component is supported in RGB24\n");
  }
  
  // Read image
  p = *pic;
  for(j=0; j<h; j++) 
    if (*colormode == CM_GRAY) {
      for(i=0; i<w; i++,p++) 
	if (i<ow && j<oh) {
	  if (*maxcolor < 256) {
	    *p = fgetc(in);
	    if (*p<0) TERMINATE("Premature enf of PNM reached");
	  } else {
	    c1 = fgetc(in); c2 = fgetc(in);
	    if (c2<0) TERMINATE("Premature enf of PNM reached");
	    *p = c1 | (c2<<8);
	  }
	} else *p = *(*pic + w*(j<oh?j:oh-1) + (i<ow?i:ow-1));
    } else if (*colormode == CM_RGB24) {
      for(i=0; i<w; i++) 
	if (i<ow && j<oh) {
	  *p++ = fgetc(in); *p++ = fgetc(in); *p++ = fgetc(in);
	} else {
	  g = (*pic + (3*w)*(j<oh?j:oh) + 3*(i<ow?i:ow));
	  *p++ = *g++;	  *p++ = *g++;	  *p++ = *g++;
	}
    }
}

/* Save PNM file */
void save_pnm(FILE *out, float *pic, int width, int height, 
	      int orig_width, int orig_height, int maxcolor, 
	      BYTE colormode) {
  int i,j,k;
  float *p;

  /* Only gray scale supported */
  switch (colormode) {
  case CM_GRAY: 

    /* Write header */
    fprintf(out,"P5\n# wic\n%i %i\n%i\n",orig_width,orig_height,maxcolor);
    
    /* Write image */
    for (j=0; j<orig_height; j++) {
      p=pic+width*j;
      for (i=0; i<orig_width; i++,p++) {
	k = (int)*p; 
	if(k>maxcolor) k=maxcolor;
	if (k<0) k=0;
	if (maxcolor <256) fputc(k,out); 
	else {
	    fputc(k & 0xff,out); 
	    fputc(k >> 8,out); 
	}
      }
    }
    
  break;

  case CM_RGB24: 

    /* Write header */
    fprintf(out,"P6\n# wic\n%i %i\n255\n",orig_width,orig_height);
    
    /* Write image */
    for (j=0; j<orig_height; j++) {
      p=pic+width*j*3;
      for (i=0; i<orig_width; i++) {
	k = (int)*p++; if(k>255) k=255; if (k<0) k=0; fputc(k,out);
	k = (int)*p++; if(k>255) k=255; if (k<0) k=0; fputc(k,out);
	k = (int)*p++; if(k>255) k=255; if (k<0) k=0; fputc(k,out);
      }
    }
    
  break;
  
  default: 

    TERMINATE("Unsupported colormode");
  }
}
